-- SQL script to drop the table structure of the SCASS DNS module
-- 
-- author: Alexander Schreiber <als@thangorodrim.de>
-- version: $Id: drop_dns.sql,v 1.1 2002/06/29 23:06:47 sshcvs Exp $
--

-- first, drop the triggers
DROP TRIGGER dns_zone_set_last_update ON dns_zone;
DROP TRIGGER dns_mapping_set_last_update ON dns_mapping;
DROP TRIGGER dns_alias_set_last_update ON dns_alias;
DROP TRIGGER dns_special_set_last_update ON dns_special;
DROP TRIGGER dns_zone_check_zone_name ON dns_zone;
DROP TRIGGER dns_mapping_check_hostname ON dns_mapping;
DROP TRIGGER dns_alias_check_hostname ON dns_alias;

-- and the rules,
DROP RULE dns_special_delete;

-- then the tables
DROP TABLE dns_alias;
DROP TABLE dns_mapping;
DROP TABLE dns_special;
DROP TABLE dns_special_types;
DROP TABLE dns_zone;

-- and finally the sequences
DROP SEQUENCE dns_alias;
DROP SEQUENCE dns_mapping;
DROP SEQUENCE dns_special;
DROP SEQUENCE dns_special_types;
DROP SEQUENCE dns_zone;

