-- table structure for SCASS internal configuration data
--
-- author: Alexander Schreiber <als@thangorodrim.de>
-- version: $Id: scass_config.sql,v 1.5 2002/09/09 00:39:26 als Exp $
--

-- global configuration data
create table scass_config (
    id serial primary key, 
    key varchar unique not null, 
    value varchar default NULL, 
    comment text default NULL, 
    last_update timestamp not null default current_timestamp
);

-- triggers to keep the last_update timestamps current
CREATE TRIGGER scass_config_set_last_update BEFORE INSERT OR UPDATE ON scass_config FOR EACH ROW EXECUTE PROCEDURE set_last_update();


create table scass_table_description (
    id serial primary key,
    table_name varchar unique not null,
    description varchar,
    comment text default NULL
);

