-- initial configuration for SCASS
--
-- Author: Alexander Schreiber <als@thangorodrim.de>
-- Version: $Id: scass_config__data.sql,v 1.9 2002/09/10 01:01:00 als Exp $
--

INSERT INTO "scass_config" (key,value,comment) VALUES (
    'SCASS.BESBase',
    '/opt/scass.bes',
    'base directory'
);

INSERT INTO "scass_config" (key,value,comment) VALUES (
    'DNSType',
    'bind',
    'type of DNS server'
);

INSERT INTO "scass_config" (key,value,comment) VALUES (
    'BindZonefileDir',
    '/opt/scass.data/DNS',
    'location of BIND zone files'
);

INSERT INTO "scass_config" (key,value,comment) VALUES (
    'BindReloadCommand',
    '/usr/sbin/rndc reload',
    'command to reload BIND'
);

INSERT INTO "scass_config" (key,value,comment) VALUES (
    'NamedIncludeFile', 
    '/opt/scass.data/named.include', 
    'path to the named include file'
);

INSERT INTO "scass_config" (key,value,comment) VALUES (
    'HTMLTableLightRowBackground',
    '#E0F8E0',
    'light background color for tables (stripe effect)'
);

INSERT INTO "scass_config" (key,value,comment) VALUES (
    'HTMLTableDarkRowBackground',
    '#C0FFC0',
    'dark background color for tables (stripe effect)'
);

INSERT INTO "scass_config" (key,value,comment) VALUES (
    'HTMLBackground',
    '#FDF6E6',
    'background color for all pages'
);

INSERT INTO scass_config (key,value,comment) VALUES (
    'DHCPType',
    'ISC-DHCPd',
    'ISC DHCP server daemon'
);

INSERT INTO "scass_config" (key,value,comment) VALUES (
    'DHCPdConffileDir',
    '/opt/scass.data/DHCP',
    'location of DHCP server config files'
);

INSERT INTO "scass_config" (key,value,comment) VALUES (
    'ISCDHCPdReloadCommand',
    '/etc/init.d/dhcp restart',
    'command to reload dhcp daemon'
);


INSERT INTO "scass_table_description" (table_name, description) VALUES (
    'scass_config',
    'SCASS configuration data'
);
INSERT INTO "scass_table_description" (table_name, description) VALUES (
    'scass_table_description',
    'SCASS table descriptions'
);
INSERT INTO "scass_table_description" (table_name, description) VALUES (
    'dns_zone',
    'DNS zones'
);
INSERT INTO "scass_table_description" (table_name, description) VALUES (
    'dns_mapping',
    'DNS host to IP mapping'
);
INSERT INTO "scass_table_description" (table_name, description) VALUES (
    'dns_alias',
    'DNS alias mapping'
);
INSERT INTO "scass_table_description" (table_name, description) VALUES (
    'dns_special_types',
    'DNS special record types'
);
INSERT INTO "scass_table_description" (table_name, description) VALUES (
    'dns_special',
    'DNS special records'
);
INSERT INTO "scass_table_description" (table_name, description) VALUES (
    'scass_fes_modules',
    'SCASS FES modules'
);
INSERT INTO "scass_table_description" (table_name, description) VALUES (
    'scass_fes_menu',
    'SCASS FES menu'
);
INSERT INTO "scass_table_description" (table_name, description) VALUES (
    'lm_platform',
    'platforms'
);
INSERT INTO "scass_table_description" (table_name, description) VALUES (
    'lm_vendor',
    'vendors'
);
INSERT INTO "scass_table_description" (table_name, description) VALUES (
    'lm_class',
    'software classes'
);
INSERT INTO "scass_table_description" (table_name, description) VALUES (
    'lm_license',
    'license types'
);
INSERT INTO "scass_table_description" (table_name, description) VALUES (
    'lm_software',
    'software entries'
);
INSERT INTO "scass_table_description" (table_name, description) VALUES (
    'lm_installation',
    'installation entries'
);

INSERT INTO "scass_table_description" (table_name, description) VALUES (
    'dhcp_net',
    'DHCP network groups'
);
INSERT INTO "scass_table_description" (table_name, description) VALUES (
    'dhcp_host',
    'DHCP host entries'
);
INSERT INTO "scass_table_description" (table_name, description) VALUES (
    'dhcp_range',
    'DHCP range entries'
);

