-- Builds the table structure for the DHCP manager
-- version: $Id: scass_dhcp.sql,v 1.10 2002/09/06 03:54:45 als Exp $
-- author: Alexander Schreiber <als@thangorodrim.de>

create table dhcp_net (
    id serial primary key,
    net_name varchar unique not NULL,
    subnet_mask inet not NULL,
    default_lease_time integer check (default_lease_time > 0) not NULL default 600,
    max_lease_time integer check (max_lease_time >= default_lease_time ) not NULL default 7200,
    ntp_servers varchar default NULL,
    routers varchar default NULL,
    domain_name varchar default NULL,
    domain_name_server varchar default NULL,
    comment text,
    last_update timestamp not null default current_timestamp,
    last_commit timestamp not null default 'epoch', 
    do_commit boolean not NULL default false
);

create table dhcp_host (
    id serial primary key,
    net integer NOT NULL references dhcp_net,
    hostname varchar not null,
    ethernet_address macaddr not null,
    fixed_address inet not null,
    comment text,
    last_update timestamp not null default current_timestamp
);


create table dhcp_range (
    id serial primary key,
    net integer NOT NULL references dhcp_net, 
    subnet cidr not null,
    range_from inet not null,
    range_to inet not null check (range_from < range_to),
    routers varchar,
    comment text,
    last_update timestamp not null default current_timestamp
);


-- triggers - first the triggers to maintain the last_update timestamps

CREATE TRIGGER dhcp_net_set_last_update 
    BEFORE INSERT OR UPDATE 
    ON dhcp_net FOR EACH ROW EXECUTE PROCEDURE set_last_update();
CREATE TRIGGER dhcp_host 
    BEFORE INSERT OR UPDATE 
    ON dhcp_host FOR EACH ROW EXECUTE PROCEDURE set_last_update();
CREATE TRIGGER dhcp_range_set_last_update 
    BEFORE INSERT OR UPDATE 
    ON dhcp_range FOR EACH ROW EXECUTE PROCEDURE set_last_update();


-- triggers to catch configuration errors for DHCP
-- the trigger only fire on identical net ids
-- catch overlapping ranges
CREATE TRIGGER dhcp_range_collision 
    BEFORE INSERT OR UPDATE 
    ON dhcp_range 
    FOR EACH ROW EXECUTE PROCEDURE check_range_collision();

-- catch host entries being insert into a range
CREATE TRIGGER dhcp_ip_range_collision 
    BEFORE INSERT OR UPDATE 
    ON dhcp_host 
    FOR EACH ROW EXECUTE PROCEDURE check_ip_range_collision();

-- catch ranges being inserted overlapping host entries 
CREATE TRIGGER dhcp_range_ip_collision 
    BEFORE INSERT OR UPDATE 
    ON dhcp_range 
    FOR EACH ROW EXECUTE PROCEDURE check_range_ip_collision();

-- catch duplicate (same IP _and_ ethernet address) entries for hosts
CREATE TRIGGER dhcp_ip_collision 
    BEFORE INSERT OR UPDATE 
    ON dhcp_host 
    FOR EACH ROW EXECUTE PROCEDURE check_ip_collision();

