-- create the table structure for SCASS (System Configuration and 
-- Administration Support System), DNS management module
--
-- version $Id: scass_dns.sql,v 1.4 2002/09/06 03:54:45 als Exp $
-- 

\connect scass


-- first, DNS management
create table dns_zone (
    id serial primary key, 
    zone_name varchar unique not null, 
    domain varchar not null, 
    network varchar not null, 
    serial integer not null default 0, 
    last_update timestamp not null default current_timestamp, 
    primary_ns varchar not null, 
    refresh int not null, 
    retry int not null, 
    expire int not null, 
    minimum int not null, 
    zone_admin varchar not null, 
    comment text, 
    last_commit timestamp not null default 'epoch', 
    do_commit boolean not NULL default false
);

create table dns_mapping (
    id serial primary key, 
    zone integer references dns_zone not null,
    last_update timestamp not null default current_timestamp, 
    IP inet not null, 
    hostname varchar not null, 
    comment text, 
    txt varchar default NULL, 
    hinfo varchar default NULL
);

create table dns_alias (
    id serial primary key, 
    zone integer references dns_zone not null, 
    last_update timestamp not null default current_timestamp, 
    name varchar not null, 
    target integer references dns_mapping not null, 
    comment text
);

create table dns_special_types (
    id serial primary key, 
    type varchar not null
);

create table dns_special (
    id serial primary key, 
    type integer references dns_special_types not null, 
    weight integer, 
    zone integer references dns_zone not null, 
    value varchar not null, 
    last_update timestamp not null default current_timestamp, 
    comment varchar
);

-- triggers to keep the last_update timestamps current
CREATE TRIGGER dns_zone_set_last_update BEFORE INSERT OR UPDATE ON dns_zone FOR EACH ROW EXECUTE PROCEDURE set_last_update();
CREATE TRIGGER dns_mapping_set_last_update BEFORE INSERT OR UPDATE ON dns_mapping FOR EACH ROW EXECUTE PROCEDURE set_last_update();
CREATE TRIGGER dns_alias_set_last_update BEFORE INSERT OR UPDATE ON dns_alias FOR EACH ROW EXECUTE PROCEDURE set_last_update();
CREATE TRIGGER dns_special_set_last_update BEFORE INSERT OR UPDATE ON dns_special FOR EACH ROW EXECUTE PROCEDURE set_last_update();

-- trigger to accept only certain chars in zone_name
CREATE TRIGGER dns_zone_check_zone_name BEFORE INSERT OR UPDATE ON dns_zone FOR EACH ROW EXECUTE PROCEDURE check_zone_name();


--
-- some rules to make life easier

-- upon deletion of a zone, also delete all its special records automagically

CREATE RULE dns_special_delete AS ON DELETE TO dns_zone DO DELETE FROM dns_special where zone = old.id;

-- initial data
INSERT INTO dns_special_types values (1, 'MX');
INSERT INTO dns_special_types values (2, 'NS');


-- triggers to enforce valid hostnames
CREATE TRIGGER dns_mapping_check_hostname BEFORE INSERT OR UPDATE ON dns_mapping FOR EACH ROW EXECUTE PROCEDURE check_hostname();
CREATE TRIGGER dns_alias_check_hostname BEFORE INSERT OR UPDATE ON dns_alias FOR EACH ROW EXECUTE PROCEDURE check_host_name();

