-- SQL script loading the menu structure data into the scass_fes* tables
--
-- author: Alexander Schreiber <als@thangorodrim.de>
-- version: $Id: scass_fes__data.sql,v 1.13 2002/09/03 11:43:00 als Exp $
--

-- init modules

INSERT INTO scass_fes_modules 
    (module_name, module_description, module_url_base, active)
    VALUES
    (
        'dns_admin',
        'DNS administration',
        'scass_dns.php',
        true
    );

INSERT INTO scass_fes_modules
    (module_name, module_description, module_url_base, active)
    VALUES
    (
        'license_manager',
        'software license management',
        'scass_lm.php',
        true
    );

INSERT INTO scass_fes_modules
    (module_name, module_description, module_url_base, active, comment)
    VALUES
    (
        '',
        'SCASS - System Configuration and Administration Support System',
        'scass.php',
        true,
        'the system itself'
    );

INSERT INTO scass_fes_modules
    (module_name, module_description, module_url_base, active)
    VALUES
    (
        'dhcp_admin',
        'DHCP management',
        'scass_dhcp.php',
        true
    );


-- init menus

INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'dns_admin'),
        'show_zones',
        'show zones',
        'scass_dns.php?job=select_show',
        true
    );


INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'dns_admin'),
        'edit_zones',
        'edit zones',
        'scass_dns.php?job=select_edit',
        true
    ); 

INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'dns_admin'),
        'add zone',
        'add zone',
        'scass_dns.php?job=add_zone',
        true
    );

INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'dns_admin'),
        'activate_changes',
        'activate changes',
        'scass_dns.php?job=activate',
        true
    ); 

INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'license_manager'),
        'add_software',
        'add software',
        'scass_lm.php?job=add_software',
        true
    ); 

INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'license_manager'),
        'edit_software',
        'edit software',
        'scass_lm.php?job=edit_software',
        true
    );

INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'license_manager'),
        'add_data_selector',
        'add base data',
        'scass_lm.php?job=add_data_selector',
        true
    );

INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'license_manager'),
        'show_data_selector',
        'show base data',
        'scass_lm.php?job=show_data_selector',
        true
    );

INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'license_manager'),
        'edit_data_selector',
        'edit base data',
        'scass_lm.php?job=edit_data_selector',
        true
    );

INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'license_manager'),
        'delete_data_selector',
        'delete base data',
        'scass_lm.php?job=delete_data_selector',
        true
    );

INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'license_manager'),
        'add_installation',
        'add installation',
        'scass_lm.php?job=add_installation',
        true
    );

INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'license_manager'),
        'delete_installation',
        'delete installation',
        'scass_lm.php?job=delete_installation',
        true
    );

INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'license_manager'),
        'show_installation',
        'show installation',
        'scass_lm.php?job=show_installation',
        true
    );

INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (   
        (select id from scass_fes_modules where module_name = 'license_manager'),
        'edit_installation',
        'edit installation',
        'scass_lm.php?job=edit_installation',
        true
    );

INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'license_manager'),
        'show_software_full',
        'show software (full listing)',
        'scass_lm.php?job=show_software_full',
        true
    );
    
INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'license_manager'),
        'show_software_short',
        'show software (short listing)',
        'scass_lm.php?job=show_software_short',
        true
    );


INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'dhcp_admin'),
        'show_host',
        'show host entries',
        'scass_dhcp.php?job=show_host',
        true
    );

INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'dhcp_admin'),
        'show_net',
        'show net entries',
        'scass_dhcp.php?job=show_net',
        true
    );

INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'dhcp_admin'),
        'show_range',
        'show range entries',
        'scass_dhcp.php?job=show_range',
        true
    );


INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'dhcp_admin'),
        'add_host',
        'add host entries',
        'scass_dhcp.php?job=add_host',
        true
    );

INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'dhcp_admin'),
        'add_net',
        'add net entries',
        'scass_dhcp.php?job=add_net',
        true
    );

INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'dhcp_admin'),
        'add_range',
        'add range entries',
        'scass_dhcp.php?job=add_range',
        true
    );


INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'dhcp_admin'),
        'delete_host',
        'delete host entries',
        'scass_dhcp.php?job=delete_host',
        true
    );

INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'dhcp_admin'),
        'delete_net',
        'delete net entries',
        'scass_dhcp.php?job=delete_net',
        true
    );

INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'dhcp_admin'),
        'delete_range',
        'delete range entries',
        'scass_dhcp.php?job=delete_range',
        true
    );

INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'dhcp_admin'),
        'activate', 
        'activate DHCP changes',
        'scass_dhcp.php?job=activate',
        true
    );

INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'dhcp_admin'),
        'edit_dhcp_net',
        'edit DHCP net',
        'scass_dhcp.php?job=edit_net',
        true
    );

INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'dhcp_admin'),
        'edit_dhcp_range',
        'edit DHCP range',
        'scass_dhcp.php?job=edit_range',
        true
    );

INSERT INTO scass_fes_menu
    (module, menu_name, menu_description, menu_url_base, active)
    VALUES
    (
        (select id from scass_fes_modules where module_name = 'dhcp_admin'),
        'edit_dhcp_host',
        'edit DHCP host',
        'scass_dhcp.php?job=edit_host',
        true
    );

