-- scass_lm.sql - set up the table structure for the SCASS license management
-- module
-- 
-- author: Alexander Schreiber <als@thangorodrim.de>
-- version: $Id: scass_lm.sql,v 1.7 2002/07/31 19:56:38 sshcvs Exp $
--

create table lm_platform (
    id serial primary key, 
    platform_name varchar unique not NULL, 
    comment text,
    last_update timestamp not null default current_timestamp
);

create table lm_vendor (
    id serial primary key, 
    vendor_name varchar unique not NULL, 
    comment text,
    last_update timestamp not null default current_timestamp
);

create table lm_class (
    id serial primary key, 
    class_name varchar unique not NULL, 
    comment text,
    last_update timestamp not null default current_timestamp
);

create table lm_license (
    id serial primary key, 
    license_name varchar unique not NULL, 
    license_text text, 
    comment text,
    last_update timestamp not null default current_timestamp
);

create table lm_software (
    id serial primary key,
    software_name varchar unique not null,
    platform int references lm_platform not null,
    vendor int references lm_vendor not null,
    class int references lm_class not null,
    license int references lm_license not null,
    description text,
    comment text,
    total_licenses int check ( total_licenses > -1 ) not null default 0,
    installed_licenses int check ( installed_licenses > -1 ) not null default 0,
    reserved_licenses int check ( reserved_licenses > -1 ) not null default 0,
    install_source varchar,
    last_update timestamp not null default current_timestamp,
    last_notify timestamp not null default 'epoch'
);

-- needs triggers to keep the license counts valid
create table lm_installation (
    id serial primary key,
    software int references lm_software not null,
    location varchar,
    count int check (count > -1) not null default 0,
    comment text,
    last_update timestamp not null default current_timestamp
);

-- triggers to update lm_software.installed_licenses upon changes to
-- lm_installation
CREATE TRIGGER lm_installation_handle_insert BEFORE INSERT ON lm_installation FOR EACH ROW EXECUTE PROCEDURE handle_add_installation();
CREATE TRIGGER lm_installation_handle_delete BEFORE DELETE ON lm_installation FOR EACH ROW EXECUTE PROCEDURE handle_delete_installation();
CREATE TRIGGER lm_installation_handle_update BEFORE UPDATE ON lm_installation FOR EACH ROW EXECUTE PROCEDURE handle_update_installation();


-- triggers to keep last_update current 

CREATE TRIGGER lm_platform_set_last_update BEFORE INSERT OR UPDATE ON lm_platform FOR EACH ROW EXECUTE PROCEDURE set_last_update();
CREATE TRIGGER lm_vendor_set_last_update BEFORE INSERT OR UPDATE ON lm_vendor FOR EACH ROW EXECUTE PROCEDURE set_last_update();
CREATE TRIGGER lm_class_set_last_update BEFORE INSERT OR UPDATE ON lm_class FOR EACH ROW EXECUTE PROCEDURE set_last_update();
CREATE TRIGGER lm_license_set_last_update BEFORE INSERT OR UPDATE ON lm_license FOR EACH ROW EXECUTE PROCEDURE set_last_update();
CREATE TRIGGER lm_software_set_last_update BEFORE INSERT OR UPDATE ON lm_software FOR EACH ROW EXECUTE PROCEDURE set_last_update();
CREATE TRIGGER lm_installation_set_last_update BEFORE INSERT OR UPDATE ON lm_installation FOR EACH ROW EXECUTE PROCEDURE set_last_update();


