#
# db_connect.pl - routine for connecting to the database
#
# Author: Alexander Schreiber <als@thangorodrim.de>
# Version: $Id: db_connect.pl,v 1.1 2002/06/24 00:56:56 sshcvs Exp $
#

sub db_connect {

    my $dsn = shift;
    my $user = shift;
    my $password = shift;

    my $dbh;
    
    $dbh = DBI->connect($dsn, $user, $password,
                         { RaiseError => 1, AutoCommit => 1 });

    if ( not defined ($dbh) ) {
        print STDERR "Failed to connect to database ($dsn)!\n";
        return -1;
    } else {
        return $dbh;
    }
}

1;

