sub load_config {
    my $config_file = shift;
    
    my $line;
    my $parameter;
    my $value;

    my %config;

    my $error = 0;

    if ( !defined($config_file) ) {
        $config_file = '';
    }

    if ( $config_file eq '' ) {
        $config_file = '/etc/scass-bes.conf'; # default config file
    }

    open(CONFIG, "<$config_file") or $error = 1;
    if ( $error == 1 ) {
        $config{'-1'} = "Failed to load configfile $config_file";
        return %config;
    }

    while ( $line = <CONFIG> ) {
        unless ( $line =~ /^#/ ) { # skip over comment lines
            $line =~ s/\n//;
            $line =~ /(\S+)\s*=\s*(.+)/;
            $parameter = $1;
            $value = $2;
            if ( defined($parameter) ) {
                $config{$parameter} = $value;
            }
        }
    }


    close(CONFIG);

    return %config;    
}

1;

