# timestamping routines of different sorts
#
# Author: Alexander Schreiber <als@thangorodrim.de>
#
# version: $Id: timestamp.pm,v 1.1 2002/06/12 23:02:21 sshcvs Exp $
#

sub get_sql_timestamp {
# creates an SQL timestamp
# parameters: $time (optional, as seconds since the epoch (time_t)
#             if empty, NOW is assumed
# call: $time_stamp = &get_sql_timestamp() 
#   or  $time_stamp = &get_sql_timestamp($time_t)
# returns: current time as SQL timestamp

    my $time = shift;

    my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst);
    my $timestamp;


    if ( $time eq '' ) {
        ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = 
                                                             localtime(time);
    } else {
        ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = 
                                                             localtime($time);
    }

    $year += 1900;
    $mon++;

    $timestamp = sprintf("%04d-%02d-%02d %02d:%02d:%02d", $year, $mon, 
                         $mday, $hour, $min, $sec);

    return $timestamp;
}

sub get_ISO8601_timestamp {
# creates an ISO8601 timestamp
# parameters: $time (optional, as seconds since the epoch (time_t)
#             if empty, NOW is assumed
# call: $time_stamp = &get_ISO8601_timestamp() 
#   or  $time_stamp = &get_ISO8601_timestamp($time_t)
# returns: current time as ISO8601 timestamp

    my $time = shift;

    my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst);
    my $timestamp;


    if ( $time eq '' ) {
        ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) =
                                                             localtime(time);
    } else {
        ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) =
                                                             localtime($time);
    }

    $year += 1900;
    $mon++;

    $timestamp = sprintf("%04d-%02d-%02dT%02d%02d%02d", $year, $mon,
                         $mday, $hour, $min, $sec);

    return $timestamp;
}

sub get_daystamp {
# creates a daystamp
# parameters: $time (optional, as seconds since the epoch (time_t)
#             if empty, NOW is assumed
# call: $day_stamp = &get_ISO8601_daystamp() 
#   or  $day_stamp = &get_ISO8601_daystamp($time_t)
# returns: current day as ISO8601 daystamp

    my $time = shift;

    my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst);
    my $daystamp;


    if ( $time eq '' ) {
        ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) =
                                                             localtime(time);
    } else {
        ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) =
                                                             localtime($time);
    }

    $year += 1900;
    $mon++;

    $daystamp = sprintf("%04d%02d%02d", $year, $mon, $mday);

    return $daystamp;
}



1;
