<?php
// misc. database related helper functions
// author: Alexander Schreiber <als@thangorodrim.de>
// version: $Id: db_helpers.php,v 1.14 2002/08/29 23:12:35 sshcvs Exp $
//

function delete_from_simple_table ($database,
                            $table,
                            $fields,
                            $order_by) {
// $database => database handle, -1 == get public handle locally and close
//              it again
// display a flat table without resolving any references
// $table => name of table to read from
// $fields => hash, keys = field names, values = field descriptions
// $order_by => order by criteria, can be empty (ex.: "fieldname")
// note: This code assumes the existence of the unique key "id" in each
// table and will fail if this column doesn't exist

    if ( $database == -1 ) {
        $database = public_db_signon();
        $close_db = true;
    } else {
        $close_db = false;
    }

    $description = get_table_description($database, $table);

    $config_db = get_config_from_db($database);

    echo "<h1>delete $description</h1>\n";

// check key args
    if ( $table == '' ) {
        print_error("delete_from_simple_table() needs table name");
        return -1;
    }
    if ( sizeof($fields) == 0 ) {
        print_error("delete_from_simple_table()need list of fields to display");
        return -1;
    }

    $first = 1;
    foreach ( array_keys($fields) as $field ) {
        if ( $first == 1 ) {
            $keys = "$field";
            $first = 0;
        } else {
            $keys .= ", $field";
        }
    }

    $sql = "SELECT id,$keys from $table ";
    if ( $order_by != '' ) {
        $sql .= " order by $order_by";
    }

    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to select data, database error: <tt>$message</tt>\n";
        return -1;
    }
    
    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "Nothing found - no data inserted yet?\n";
        // an empty table is an unlikely, but still valid condition
        return 0;
    }
    
    echo "<form action=\"scass_lm.php\" method=\"POST\">\n";

// print table head

    echo "<table bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
//    echo "<thead bgcolor=\"FDF6E6\">\n";
    echo "<thead>\n";
    echo "<th>entry</th>\n";
    echo "<th>delete</th>\n";
    foreach ( $fields as $field ) {
        echo "<th>$field</th>\n";
    }
    echo "</thead>\n";

    for ( $count = 0; $count < $rows; $count++ ) {
//        echo "<tr>\n";
        if ( $count % 2 == 1 ) {
            echo "<tr bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
        } else {
            echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
        }
        $display_count = $count + 1;
        $data = pg_fetch_object($result, $count);
        $id = $data->id;
        hidden_form_entry("id_${count}", $id);
        echo "<td align=\"right\">\n";
        echo "$display_count\n";
        echo "</td>\n";
        echo "<td align=\"center\">\n";
        $work = "_delete_${count}";
        echo "<input type=\"checkbox\" name=\"$work\" value=\"true\">\n";
        echo "</td>\n";
        foreach ( array_keys($fields) as $field ) {
            $value = stripslashes($data->$field);
            echo "<td>\n";
            $name = "${field}_${count}";
            echo "$value\n";
            echo "</td>\n";
        }
        echo "</tr>\n";
    }
    echo "</table>\n";

    print_db_auth_form();

    echo "<br>\n";

    hidden_form_entry('job', 'delete_from_simple_table_commit');
    hidden_form_entry('delete_count', $rows);

    echo "<input type=\"submit\" value=\" commit \">\n";
    echo "<input type=\"reset\" value=\" clear \">\n";


    hidden_form_entry('table', $table);
    $work = rawurlencode("delete $description");
    hidden_form_entry(title, $work);

    echo "</form>\n";

    if ( $close_db == true ) {
        pg_close($database);
    }

    return 0;

}


function delete_from_simple_table_commit ($post) {

    $title = rawurldecode($post[title]);

    echo "<h1>$title - commit</h1>\n";

    $database = db_signon($post['DB_USER'], $post['DB_PASSWORD']);
    if ( $database == -1 ) {
        textmodule_database_login_failure();

        return;
    }

    $delete_count = $post[delete_count];
    $table = $post[table];

    $records_deleted = 0;


    for ( $count = 0; $count < $delete_count; $count++ ) {
        $field = "id_${count}";
        $id = $post[$field];
        $field = "_delete_$count";
        if ( $post[$field] == 'true' ) {
            $sql = "DELETE FROM $table WHERE id = $id";
            $result = pg_exec($database, $sql);
            if ( $result == false ) {
                $message = pg_errormessage($database);
                echo "Database error message: <tt>$message</tt>\n";
                if (preg_match("/referential integrity violation/", $message)){
                    display_reference_matches($table);
                }
            } else {
                $records_deleted += pg_cmdtuples($result);
            }
        }

    }

    textmodule_db_action_summary('deleted', $records_deleted);

    pg_close($database);

    return 0;

}

function display_reference_matches ($table) {
// displays tableentries from tables referencing $table
// needs structural knowledge of the database
// FIXME: dummy function display_reference_matches($table)

}


function edit_simple_table ($database, 
                            $table, 
                            $fields, 
                            $field_types, 
                            $order_by,
                            $php_handler) {
// $database => database handle, -1 == get public handle locally and close
//              it again
// display a flat table without resolving any references
// $table => name of table to read from
// $fields => hash, keys = field names, values = field descriptions
// $order_by => order by criteria, can be empty (ex.: "fieldname")
// $php_handler => PHP file to handle the form
// note: This code assumes the existence of the unique key "id" in each
// table and will fail if this column doesn't exist

    if ( $database == -1 ) {
        $database = public_db_signon();
        $close_db = true;
    } else {
        $close_db = false;
    }

    $description = get_table_description($database, $table);

    $config_db = get_config_from_db($database);

    echo "<h1>edit $description</h1>\n";

// check key args
    if ( $table == '' ) {
        print_error("edit_simple_table() needs table name");
        return -1;
    }
    if ( sizeof($fields) == 0 ) {
        print_error("edit_simple_table() needs list of fields to display");
        return -1;
    }

    $first = 1;
    foreach ( array_keys($fields) as $field ) {
        if ( $first == 1 ) {
            $keys = "$field";
            $first = 0;
        } else {
            $keys .= ", $field";
        }
    }

    $sql = "SELECT id,$keys from $table ";
    if ( $order_by != '' ) {
        $sql .= " order by $order_by";
    }

    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to select data, database error: <tt>$message</tt>\n";
        return -1;
    }

    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "Nothing found - no data inserted yet?\n";
        // an empty table is an unlikely, but still valid condition
        return 0;
    }

    echo "<form action=\"$php_handler\" method=\"POST\">\n";

// print table head

    echo "<table bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
//    echo "<thead bgcolor=\"FDF6E6\">\n";
    echo "<thead>\n";
    echo "<th>entry</th>\n";
    echo "<th>update</th>\n";
    foreach ( $fields as $field ) {
        echo "<th>$field</th>\n";
    }
    echo "</thead>\n";

    for ( $count = 0; $count < $rows; $count++ ) {
//        echo "<tr>\n";
        if ( $count % 2 == 1 ) {
            echo "<tr bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
        } else {
            echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
        }
        $display_count = $count + 1;
        $data = pg_fetch_object($result, $count);
        $id = $data->id;
        hidden_form_entry("id_${count}", $id); 
        echo "<td align=\"right\">\n";
        echo "$display_count\n";
        echo "</td>\n";
        echo "<td align=\"center\">\n";
        $work = "_update_${count}";
        echo "<input type=\"checkbox\" name=\"$work\" value=\"true\">\n";
        echo "</td>\n";
        foreach ( array_keys($fields) as $field ) {
            $value = stripslashes($data->$field);
            echo "<td>\n";
            $name = "${field}_${count}";

            switch ( $field_types[$field] ){
                case 'shortline':
                    echo "<input type=\"text\" name=\"$name\" ";
                    echo "size=\"8\" value=\"$value\">\n";
                    break;

                case 'line':
                    echo "<input type=\"text\" name=\"$name\" ";
                    echo "size=\"16\" value=\"$value\">\n";
                    break;
                case 'longline':
                    echo "<input type=\"text\" name=\"$name\" ";
                    echo "size=\"32\" value=\"$value\">\n";
                    break;
                case 'textarea':
                    echo "<textarea name=\"$name\" ";
                    echo "cols=\"30\" rows=\"10\">$value</textarea>";
                    break;
                case 'file':
                    echo "<input name=\"$name\" type=\"file\" ";
                    echo "size=\"30\" maxlength=\"65536\" ";
                    echo "accept=\"text/*\">\n";
                    break;
                default:
                    echo "<input type=\"text\" name=\"$name\" ";
                    echo "size=\"16\" value=\"$value\">\n";
                    break;
            }



            echo "</td>\n";
        }
        echo "</tr>\n";
    }
    echo "</table>\n";

    print_db_auth_form();

    echo "<br>\n";

    hidden_form_entry('job', 'edit_simple_table_commit');
    hidden_form_entry('edit_count', $rows);

    echo "<input type=\"submit\" value=\" commit \">\n";
    echo "<input type=\"reset\" value=\" clear \">\n";

    $data_field_count = 0;
    foreach ( array_keys($fields) as $field ) {
        $field_label = "data_field_";
        $field_label .= "$data_field_count";
        $data_field_count++;
        hidden_form_entry($field_label, $field);
    }
    $count = 0;

    hidden_form_entry('table', $table);
    $work = rawurlencode("edit $description");
    hidden_form_entry(title, $work);
    hidden_form_entry('data_field_count', $data_field_count);

    echo "</form>\n";

    if ( $close_db == true ) {
        pg_close($database);
    }

    return 0;
}

function edit_simple_table_commit ($post) {

// the commit part of the edit_simple_table helper

    $title = rawurldecode($post[title]);

    echo "<h1>$title - commit</h1>\n";

    $database = db_signon($post['DB_USER'], $post['DB_PASSWORD']);
    if ( $database == -1 ) {
        textmodule_database_login_failure();

        return;
    }

// start loading data from the form
    $table = $post[table];
    $edit_count = $post[edit_count];
    $data_field_count = $post[data_field_count];

    for ( $count = 0; $count < $data_field_count; $count++ ) {
        $work = "data_field_";
        $work .= "$count";
        $data_fields[] = $post[$work];
    }

    $last_field = $data_fields[(count($data_fields) - 1)];

    $records_updated = 0;


    for ( $count = 0; $count < $edit_count; $count++ ) {
        $work = "_update_${count}";
        if ( $post[$work] != 'true' ) {
            continue;
        }
        $last_field = $data_fields[(count($data_fields) - 1)];
        $sql = "UPDATE $table SET ";

        foreach ( $data_fields as $field ) {
            $post_field = "$field";
            $post_field .= "_$count";
            $value = $post[$post_field];
            if ( $value == '' ) { // check for empty value and set them to NULL
                $sql .= "$field = NULL";
            } else {
                $value = addslashes($value);
                $sql .= "$field = '$value'";
            }
            if ( $field != $last_field ) {
                $sql .= ", ";
            }
        }

        $post_field = "id_${count}";
        $id = $post[$post_field];
        $sql .= " where id = $id";

        $result = pg_exec($database, $sql);

        if ( $result == false ) {
            $message = pg_errormessage($database);
            echo "Failed to add $table record.\n";
            if ( preg_match("/Fail to add null value in not null/", $message)){
                echo "One or more mandatory fields were left empty.<br>\n";
            }

            echo "The database error message is: <tt>$message</tt>\n";
        } else {
            $records_updated += pg_cmdtuples($result);
        }
    }

    textmodule_db_action_summary('updated', $records_updated);

    pg_close($database);

    return 0;

}



function get_config_from_db ($database) {
// $database => database handle, -1 == get public handle locally and close
//              it again
// returns hash with config data, loading only key and value

    if ( $database == -1 ) {
        $database = public_db_signon();
        $close_db = true;
    } else {
        $close_db = false;
    }

    $sql = "SELECT key, value from scass_config";
    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to select table, database error: <tt>$message</tt>\n";
        return -1;
    }

    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "Failed to load config data: nothing found\n";
        return -1;
    }

    for ( $count = 0; $count < $rows; $count++ ) {
        $data = pg_fetch_object($result, $count);
        $key = $data->key;
        $config[$key] = $data->value;
    } 

    if ( $close_db == true ) {
        pg_close($database);
    }

    return $config;
}

function public_db_signon () {

    $config = get_config_from_file('');

    $pg_db_string = "dbname=$config[DBName] port=$config[DBPort] ";
    $pg_db_string .= "user='$config[PublicDBUser]' host='$config[DBHost]' ";
    $pg_db_string .= "password='$config[PublicDBPassword]'";

    $database = pg_connect($pg_db_string);

    if ( $database == false ) {
            die("db_signon(): failed");
    } else {
        return $database;
    }

}

function db_signon($user, $password) {

    $config = get_config_from_file('');

    $pg_db_string = "dbname=$config[DBName] port=$config[DBPort] ";
    $pg_db_string .= "user='$user' host='$config[DBHost]' ";
    $pg_db_string .= "password='$password'";

    $database = pg_connect($pg_db_string);

    if ( $database == false ) {
        return -1;
    } else {
        return $database;
    }


}

function get_table_description ($database, $table) {
// $database => database handle, -1 == get public handle locally and close
//              it again
// $table => name of table to get description for

    if ( $database == -1 ) {
        $database = public_db_signon();
        $close_db = true;
    } else {
        $close_db = false;
    }   

    $sql = "select description from scass_table_description where ";
    $sql .= "table_name = '$table'";

    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to select table, database error: <tt>$message</tt>\n";
        return -1;
    }

    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "Failed to locate table: nothing found\n";
        return -1;
    }

    $data = pg_fetch_object($result, 0);
    $description = $data->description;

    if ( $close_db == true ) {
        pg_close($database);
    }

    return $description;
}


function get_module_description($database, $module) {
// $database => database handle, -1 == get public handle locally and close
//              it again
// $module => name of module to get description for

    if ( $database == -1 ) {
        $database = public_db_signon();
        $close_db = true;
    } else {
        $close_db = false;
    }   

    $sql = "select module_description from scass_fes_modules where ";
    $sql .= "module_name = '$module'";

    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to select modules, database error: <tt>$message</tt>\n";
        return -1;
    }

    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "Failed to locate module: nothing found\n";
        return -1;
    }

    $data = pg_fetch_object($result, 0);
    $module_description = $data->module_description;

    if ( $close_db == true ) {
        pg_close($database);
    }

    return $module_description;
}

function get_menu_description($database, $module_name, $menu_name) {
// $database => database handle, -1 == get public handle locally and close
//              it again
// $module_name => name of module containing $menu_name
// $menu_name => name of menu to get description for

    if ( $database == -1 ) {
        $database = public_db_signon();
        $close_db = true;
    } else {
        $close_db = false;
    }   

    $sql = "SELECT scass_fes_menu.menu_description from scass_fes_menu, ";
    $sql .= "scass_fes_modules where scass_fes_modules.module_name = ";
    $sql .= "'$module_name' and scass_fes_menu.menu_name = '$menu_name'";

    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to select data, database error: <tt>$message</tt>\n";
        return -1;
    }

    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "Failed to locate menu: nothing found\n";
        return -1;
    }

    $data = pg_fetch_object($result, 0);
    $menu_description = $data->menu_description;

    if ( $close_db == true ) {
        pg_close($database);
    }

    return $menu_description;
}


function display_simple_table ($database, $table, $fields, $order_by) {
// $database => database handle, -1 == get public handle locally and close
//              it again
// display a flat table without resolving any references
// $table => name of table to read from
// $fields => hash, keys = field names, values = field descriptions
// $order_by => order by criteria, can be empty (ex.: "fieldname")


    if ( $database == -1 ) {
        $database = public_db_signon();
        $close_db = true;
    } else {
        $close_db = false;
    }

    $description = get_table_description($database, $table);

    $config_db = get_config_from_db($database);

    echo "<h1>show $description</h1>\n";

// check key args
    if ( $table == '' ) {
        print_error("display_simple_table() needs table name");
        return -1;
    }
    if ( sizeof($fields) == 0 ) {
        print_error("display_simple_table() needs list of fields to display");
        return -1;
    }

    $first = 1;
    foreach ( array_keys($fields) as $field ) {
        if ( $first == 1 ) {
            $keys = "$field";
            $first = 0;
        } else {
            $keys .= ", $field";
        }
    }

    $sql = "SELECT $keys from $table ";
    if ( $order_by != '' ) {
        $sql .= " order by $order_by";
    }

    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to select data, database error: <tt>$message</tt>\n";
        return -1;
    }

    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "nothing found\n";
        // an empty table is an unlikely, but still valid condition
        return 0;
    }

// print table head

    echo "<table bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
//    echo "<thead bgcolor=\"FDF6E6\">\n";
    echo "<thead>\n";
    echo "<th>entry</th>\n";
    foreach ( $fields as $field ) {
        echo "<th>$field</th>\n";
    }
    echo "</thead>\n";

    for ( $count = 0; $count < $rows; $count++ ) {
//        echo "<tr>\n";
        if ( $count % 2 == 1 ) {
            echo "<tr bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
        } else {
            echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
        }
        $display_count = $count + 1;
        $data = pg_fetch_object($result, $count);
        echo "<td align=\"right\">$display_count</td>\n";
        foreach ( array_keys($fields) as $field ) {
            $value = nl2br(htmlentities(stripslashes($data->$field)));
            echo "<td>$value</td>\n";
        }
        echo "</tr>\n";
    }
    echo "</table>\n";

    if ( $close_db == true ) {
        pg_close($database);
    }

    return 0;
}

function display_joined_tables ($database, $main_table, $tables, $fields, 
                                $join_by, $order_by) {
// FIXME:killme?
// $database => database handle, -1 == get public handle locally and close
//              it again
// $main_table => which table name to use for display
// display joined tables
// $tables => comma-separated list of tables to load data from
// $fields => hash, keys = field names (absolute), values = field descriptions
// $join_by => join condition, required
// $order_by => order by criteria, can be empty (ex.: "fieldname")

    if ( $join_by == '' ) {
        print_error("internal error, display_joined_tables() needs join_by");
    }


    if ( $database == -1 ) {
        $database = public_db_signon();
        $close_db = true;
    } else {
        $close_db = false;
    }



    $description = get_table_description($database, $main_table);

    $config_db = get_config_from_db($database);

    echo "<h1>show $description</h1>\n";

// check key args
    if ( $tables == '' ) {
        print_error("display_joined_table() needs table names");
        return -1;
    }
    if ( sizeof($fields) == 0 ) {
        print_error("display_joined_table() needs list of fields to display");
        return -1;
    }

    $count = 0;
    $data_key_list = '';
    foreach ( array_keys($fields) as $key ) {
        $data_key = "d_${count}";
        if ( $count == 0 ) {
            $data_key_list = " $key as $data_key";
        } else {
            $data_key_list .= ", $key as $data_key";
        }
        $count++;
        $data_keys[$key] = $data_key;
    }


    $sql = "SELECT $data_key_list from $tables where $join_by";
    if ( $order_by != '' ) { 
        $sql .= " order by $order_by";
    }

    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to select data, database error: <tt>$message</tt>\n";
        return -1;
    }

    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "nothing found\n";
        // an empty table is an unlikely, but still valid condition
        return 0;
    }

// print table head


    echo "<table bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
//    echo "<thead bgcolor=\"FDF6E6\">\n";
    echo "<thead>\n";
    echo "<th>entry</th>\n";
    foreach ( $fields as $field ) {
        echo "<th>$field</th>\n";
    }
    echo "</thead>\n";
 
    for ( $count = 0; $count < $rows; $count++ ) {
//        echo "<tr>\n";
        if ( $count % 2 == 1 ) {
            echo "<tr bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
        } else {
            echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
        }
        $display_count = $count + 1;
        $data = pg_fetch_object($result, $count);
        echo "<td align=\"right\">$display_count</td>\n";
        foreach ( array_keys($fields) as $field ) {
            $key = $data_keys[$field];
            $value = nl2br(htmlentities(stripslashes($data->$key)));
            echo "<td>$value</td>\n";
        }
        echo "</tr>\n";
    }
    echo "</table>\n";
 
    if ( $close_db == true ) {
        pg_close($database);
    }
 
    return 0;
} 
 



function get_column_from_table ($database, $table, $column, $condition) {
// fetch all matching entries from a single column of a table
// $database => database handle, if -1 create (and destroy when done) a local
// $table => name of table to load from
// $column => name of olumn to read
// $condition => condition for fetching, can be empty

    
    if ( $database == -1 ) {
        $database = public_db_signon();
        $close_db = true;
    } else {
        $close_db = false;
    }

    if ( $condition == '' ) {
        $condition = ' true ';
    }

    if ( $table == '' ) {
        print_error("get_column_from_table(): table name required");
    }

    if ( $column == '' ) {
        print_error("get_column_from_table(): column name required");
    }


    $sql = "SELECT $column FROM $table WHERE $condition";
    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to select data, database error: <tt>$message</tt>\n";
        return -1;
    }
    
    $rows = pg_numrows($result);

    if ( $rows == 0 ) {
        if ( $close_db == true ) {
            pg_close($database);
        }
    
        return;
    } else {
        for ( $count = 0; $count < $rows; $count++ ) {
            $data = pg_fetch_object($result, $count);
            $column_data[] = $data->$column;
        }
        if ( $close_db == true ) {
            pg_close($database);
        }

        return $column_data;
    }
}


?>

