<?php
// misc form helpers
// author: Alexander Schreiber <als@thangorodrim.de>
// version: $Id: form_helper.php,v 1.11 2002/08/28 22:15:05 sshcvs Exp $


function show_delete_entry_table($result, $fields, $config_db) {
// print table head

    echo "<table bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
    echo "<thead>\n";
    echo "<th>entry</th>\n";
    echo "<th>delete</th>\n";
    foreach ( array_keys($fields) as $field ) {
        echo "<th>$fields[$field]</th>\n";
    }
    
    echo "</thead>\n";

    $rows = pg_numrows($result);
                     
    for ( $count = 0; $count < $rows; $count++ ) {
//        echo "<tr>\n";
        if ( $count % 2 == 1 ) {
            echo "<tr bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
        } else {
            echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
        }
        $display_count = $count + 1;
        $data = pg_fetch_object($result, $count);
        $id = $data->id;
        hidden_form_entry("id_${count}", $id);
        echo "<td align=\"right\">\n";
        echo "$display_count\n";
        echo "</td>\n";
        echo "<td align=\"center\">\n";
        $work = "_delete_${count}"; 
        echo "<input type=\"checkbox\" name=\"$work\" value=\"true\">\n";
        echo "</td>\n";
        foreach ( array_keys($fields) as $field ) {
            $value = stripslashes($data->$field);
            echo "<td>\n";
            $name = "${field}_${count}";
            echo "$value\n";
            echo "</td>\n";
        }
        echo "</tr>\n";
    }

    echo "</table>\n";
}

function form_submit_buttons () {
    echo "<input type=\"submit\" value=\" commit \">\n";
    echo "<input type=\"reset\" value=\" clear \">\n";
}

function form_entry_text_line($name, $value) {
    echo "<input type=\"text\" name=\"$name\" ";
    echo "size=\"32\" value=\"$value\">\n";
}

function form_entry_short_text_line($name, $value) {
    echo "<input type=\"text\" name=\"$name\" ";
    echo "size=\"17\" value=\"$value\">\n";
}


function form_entry_number_line($name, $value) {
    echo "<input type=\"text\" name=\"$name\" ";
    echo "size=\"8\" value=\"$value\">\n";
}

function form_entry_ip_line($name, $value) {
    echo "<input type=\"text\" name=\"$name\" ";
    echo "size=\"15\" value=\"$value\">\n";
}


function form_entry_select($name, $entries) {
    echo "<select name=\"$name\">\n";
    foreach ( $entries as $entry ) {
        echo "<option>$entry</option>\n";
    }
    echo "</select>\n";
}

function hidden_form_entry($name, $value) {
// prints a hidden form entry

    echo "<input type=\"hidden\" name=\"$name\" ";
    echo "value=\"$value\">\n";
}

function simple_add_form ($add_count, 
                          $title,
                          $table,
                          $data_fields,
                          $example_fields,
                          $required_fields,
                          $field_types) {

// $add_count => number of entries to add
// $title => title of form
// $table => table to insert into
// $data_fields => hash, keys = field names, values = field labels
// $example_fields => hash, keys = field names, values = examples
// $required_fields => fields needed for commit
// $field_types => hash, keys = field names, values = field types
//                                           (line/textarea/file)

    $database = public_db_signon();
    $config_db = get_config_from_db($database);

    $fields = array_keys($data_fields);
    $data_field_count = count($data_fields);

    echo "<h1>$title</h1>\n";

    $required = '';
    foreach ( $required_fields as $field ) {
        $required .= " $field";
    }

    textmodule_add_entry_hint($add_count, $required);
    echo "<br>\n";

    echo "<form action=\"scass_lm.php\" method=\"POST\">\n";


    echo "<table bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";

    echo "<thead>\n";
    echo "<th>entry</th>\n";
    foreach ( $fields as $field ) {
        echo "<th>$data_fields[$field]</th>\n";
    }
    echo "</thead>\n";

    echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
    echo "<td align=\"center\">example</td>\n";
    foreach ( $fields as $field ) {
        echo "<td>$example_fields[$field]</td>\n";
    }
    echo "<tr>\n";

    for ( $count = 0; $count < $add_count; $count++ ) {
        if ( $count % 2 == 0 ) {
            echo "<tr bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
        } else {
            echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
        }
        $display_count = $count + 1;
        echo "<td align=\"center\">$display_count</td>\n";
        foreach ( $fields as $field_name) {
            echo "<td>\n";
            $print_name = sprintf("%s_%s", $field_name, $count);
            switch ( $field_types[$field_name] ){
                case 'shortline':
                    echo "<input type=\"text\" name=\"$print_name\" ";
                    echo "size=\"8\">\n";
                    break;

                case 'line':
                    echo "<input type=\"text\" name=\"$print_name\" ";
                    echo "size=\"16\">\n";
                    break;
                case 'longline':
                    echo "<input type=\"text\" name=\"$print_name\" ";
                    echo "size=\"32\">\n";
                    break;
                case 'textarea':
                    echo "<textarea name=\"$print_name\" ";
                    echo "cols=\"30\" rows=\"10\"></textarea>";
                    break;
                case 'file':
                    echo "<input name=\"$print_name\" type=\"file\" ";
                    echo "size=\"30\" maxlength=\"65536\" ";
                    echo "accept=\"text/*\">\n";
                    break;
                default:
                    echo "<input type=\"text\" name=\"$print_name\" ";
                    echo "size=\"16\">\n";
                    break;
            }
            echo "</td>\n";
        }

        echo "</tr>\n";
    }

    echo "</table>\n";

    print_db_auth_form();

    echo "<br>\n";

    hidden_form_entry('job', 'simple_add_form_commit');
    hidden_form_entry('add_count', $add_count);

    echo "<input type=\"submit\" value=\" commit \">\n";
    echo "<input type=\"reset\" value=\" clear \">\n";

    $count = 0;
    foreach ( $fields as $field ) {
        $field_label = "data_field_";
        $field_label .= "$count";
        $count++;
        hidden_form_entry($field_label, $field);
        $field_label = "data_field_type_";
        $field_label .= "$count";
        hidden_form_entry($field_label, $field_types[$field]);
    }
    $count = 0;
    foreach ( $required_fields as $field ) {
        $field_label = "required_field_";
        $field_label .= "$count";
        $count++;
        hidden_form_entry($field_label, $field);
    }

    hidden_form_entry('table', $table);
    $work = rawurlencode($title);
    hidden_form_entry(title, $work);
    hidden_form_entry('data_field_count', $data_field_count);

    echo "</form>\n";

    pg_close($database);
}


function simple_add_form_commit ($post) {
// the commit part of the simple_add_form helper


    $title = rawurldecode($post[title]);

    echo "<h1>$title - commit</h1>\n";

    $database = db_signon($post['DB_USER'], $post['DB_PASSWORD']);
    if ( $database == -1 ) {
        textmodule_database_login_failure();

        return;
    }

// start loading data from the form
    $add_count = $post[add_count];
    $table = $post[table];
    $add_count = $post[add_count];
    $data_field_count = $post[data_field_count];

    for ( $count = 0; $count < $data_field_count; $count++ ) {
        $work = "data_field_";
        $work .= "$count";
        $data_fields[] = $post[$work];
        $work = "required_field_";
        $work .= "$count";
        if ( $post[$work] != '' ) {
            $required_fields[] = $post[$work];
        }
    }

    $last_field = $data_fields[(count($data_fields) - 1)];

    $records_added = 0;

    for ( $count = 0; $count < $add_count; $count++ ) {
        $last_field = $data_fields[(count($data_fields) - 1)];
        $sql = "insert into $table (";
        foreach ( $data_fields as $field ) {
            $sql .= " $field";
            if ( $field != $last_field ) {
                $sql .= ", ";
            }
        }
        $sql .= ") values (";

        foreach ( $data_fields as $field ) {
            $post_field = "$field";
            $post_field .= "_$count";
            $value = $post[$post_field];
            if ( $value == '' ) { // check for empty value and set them to NULL
                $sql .= "NULL";
            } else {
                $value = addslashes($value);
                $sql .= "'$value'";
            }
            if ( $field != $last_field ) {
                $sql .= ", ";
            }
        }

        $sql .= ")";

// check required fields
        $skip_entry = 0;
        foreach ( $required_fields as $field ) {
            $work = "$field";
            $work .= "_";
            $work .= "$count";
            if (  $post[$work] == '' ) {
                $skip_entry = 1; // skip DB insert upon this one
            }
        }

        if ( $skip_entry == 1 ) {
            continue;
        }

        $result = pg_exec($database, $sql);

        if ( $result == false ) {
            $message = pg_errormessage($database);
            echo "Failed to add $table record.\n";
            if ( preg_match("/Fail to add null value in not null/", $message)){
                echo "One or more mandatory fields were left empty.<br>\n";
            }

            echo "The database error message is: <tt>$message</tt>\n";
        } else {
            $records_added += pg_cmdtuples($result);
        }
    }

    echo "Successfully added $records_added entries.<br>\n";

    pg_close($database);

    return 0;

}





?>
