<?php

// version: $Id: helpers.php,v 1.15 2002/09/15 13:22:09 sshcvs Exp $


function is_num($value) {
    if ( preg_match("/^\d+$/", $value) ) {
        return true;
    } else {
        return false;
    }
}

function print_hash ($hash) {
    foreach ( array_keys($hash) as $key) {
        print_debug("|$key| => |$hash[$key]|");
    }
}

function print_array($array) {
    foreach ( $array as $data ) {
        print_debug("|$data|");
    }
}

function print_debug ($message) {
    print "<tt>debug: $message</tt><br>\n";
}

function print_error ($message) {
    print "<tt><strong>error:</strong>$message</tt><br>\n";
}

function https_ok ($https, $function) {
    if ( $https != 'on' ) {
        echo "<strong>error - HTTPS required for this function ";
        echo "($function)</strong>\n";
        echo "<br>\n";
        echo "For security reasons (to protect authentication data), this ";
        echo "function ($function) is only available when using SCASS via ";
        echo "https\n";
        return 0;
    } else {
        return 1;
    }
}

function print_db_auth_form () {
    echo "<h2>authentication data for database access</h2>\n";
    echo "<table>\n";
    echo "<tr>\n";
    echo "<td><strong>account</strong></td>";
    echo "<td><input name=\"DB_USER\" type=\"text\" size=16></td>\n";
    echo "</tr>\n";
    echo "<tr>\n";
    echo "<td><strong>password</strong></td>";
    echo "<td><input name=\"DB_PASSWORD\" type=\"password\" size=16></td>\n";
    echo "</tr>\n";
    echo "</table>\n";
}

function print_short_zone_header ($zone_id) {

    $database = public_db_signon();
    $result = pg_exec($database, "select domain,zone_name from dns_zone where id=$zone_id");

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to select zone, database error: <tt>$message</tt>\n";
        return -1;
    }

    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "Failed to load zone information: zone not found\n";
        return -1;
    }

    $data = pg_fetch_object($result, 0);

    echo "<table>\n";
    echo "<tr><td><b>domain</b></td><td>$data->domain &nbsp;</td></tr>\n";
    echo "<tr><td><b>zone name</b></td><td>$data->zone_name &nbsp;</td></tr>\n";
    echo "</table>\n<br>\n";

    pg_close($database);
}


function display_dns_mapping_table ($database, $condition) {
// displays the entries of the dns_mapping table as selected by $condition
// which is something along the lines of "dns_mapping.zone = 1"

    if ( $condition == '' ) {
        $condition = 'true'; // simple trick for empty conditions
    }

    $config_db = get_config_from_db($database);

    $sql =  "select dns_mapping.hostname,dns_mapping.ip,dns_mapping.hinfo,";
    $sql .= "dns_mapping.txt,dns_mapping.comment,dns_mapping.last_update ";
    $sql .= "from dns_mapping ";
    $sql .= "where $condition order by hostname";

    $result = pg_exec($database, $sql);
    if ( $result == false ) {
        $error = pg_errormessage($database);
        echo "<tt>error: $error</tt>\n";
        return;
    }
    $rows = pg_numrows($result);

    echo "\n<BR>\n";
    if ( $rows == 0 ) {
        echo "no records found\n";
    } else {
        echo "<table bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
        echo "<thead>\n";
        echo "<th>hostname</th><th>IP</th><th>TXT</th><th>HINFO</th>";
        echo "<th>last update (GMT)</th><th>comment</th>\n";
        echo "</thead>\n";

        for ( $count = 0; $count < $rows; $count++ ) {
            $data = pg_fetch_object ($result, $count);
            if ( $count % 2 == 1 ) {
                echo "<tr ";
                echo "bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
            } else {
                echo "<tr ";
                echo "bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
            }
            echo "<td>$data->hostname &nbsp;</td><td>$data->ip &nbsp;</td>";
            echo "<td>$data->txt &nbsp;</td><td>$data->hinfo &nbsp;</td>";
            echo "<td>$data->last_update &nbsp;</td>";
            echo "<td>$data->comment &nbsp;</td>\n";
            echo "</tr>\n";
        }
        echo "</table>\n";
    }

    echo "\n<BR>\n";

}


function display_dns_alias_table ($database, $condition) {
// displays the entries of the dns_alias table as selected by $condition
// which is something along the lines of "dns_alias.zone = 1"

    if ( $condition == '' ) {
        $condition = 'true'; // simple trick for empty conditions
    }

    $config_db = get_config_from_db($database);

    $sql = "SELECT distinct dns_alias.name,dns_mapping.hostname,";
    $sql .= "dns_alias.last_update,dns_alias.comment from dns_alias,";
    $sql .= "dns_mapping, dns_zone where dns_alias.target = dns_mapping.id ";
    $sql .= " and ";
    $sql .= "($condition) order by name";

    $result = pg_exec($database, $sql);
    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to select alias record data.<br>\n";
        echo "Database error message: $message<br>\n";
        return;
    }
    $rows = pg_numrows($result);

    echo "\n<BR>\n";

    if ( $rows == 0 ) {
        echo "no records found";
        return;
    }

    echo "<table bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
    echo "<th>alias name</th><th>pointing to</th><th>last update (GMT)</th>";
    echo "<th>comment</th>\n";
    for ( $count == 0; $count < $rows; $count++ ) {
        $data = pg_fetch_object($result, $count);
        if ( $count % 2 == 1 ) {
            echo "<tr bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
        } else {
            echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
        }
        echo "<td>$data->name</td>\n";
        echo "<td>$data->hostname</td>\n";
        echo "<td>$data->last_update</td>\n";
        echo "<td>$data->comment</td>\n";
        echo "</tr>\n";
    }
    echo "\n<BR>\n";

    echo "</table>\n";

    pg_freeresult($result);
}

function get_config_from_file ($cf_file) {

    $CONFIG_FILE = "/etc/scass.conf";   // global config file

    if ( $cf_file == '' ) {
        $cf_file = $CONFIG_FILE;
    }

    $cf_fd = fopen($cf_file, "r");
    if ( $cf_fd == FALSE ) {
        echo "Failure: failed to open config file.<br>\n";

        return;
    }

    while ( !(feof($cf_fd)) ) {
        $line = fgets($cf_fd, 2048); // should be enuogh for this file
        $line = preg_replace("/\n/", "", $line);
        if ( !(preg_match("/^#/", $line)) ) { // ignore comments
            $cf_line = preg_split("/\s*=\s*/", $line);
//            echo "key = |$cf_line[0]| data = |$cf_line[1]|<br>\n";
            $key = $cf_line[0];
            $value = $cf_line[1];
            $config[$key] = $value;
        }
    }

    $config_keys = array('PublicDBUser', 'PublicDBPassword', 'DBHost',
                          'DBPort', 'DBName');

    foreach ( $config_keys as $config_key ) { 
        if ( $config[$config_key] == '' ) {
            echo "Failure: config value $config_key not found.<br>\n";
        } 
    } 

    fclose($cf_fd);

    return $config;
}


?>
