<?php

// sidebar.php - implements the menu sidebar
// author: Alexander Schreiber <als@thangorodrim.de>
// version: $Id: sidebar.php,v 1.6 2002/08/29 22:55:35 sshcvs Exp $

function display_sidebar_top ($database, $current_module) {
// $database => database handle, -1 == get public handle locally and close
//              it again
// $current_module => currently active module, can be empty

    if ( $database == -1 ) {
        $database = public_db_signon();
        $close_db = true;
    } else {
        $close_db = false;
    }


// print head
    echo "<table border=0>\n";
    echo "<tr>\n";
    echo "<td valign=top>\n";
    echo "<a href=\"scass.php\"><h1>SCASS</h1></a>\n";
    echo "<h2>available modules</h2>\n";
    echo "<ul>\n";
    $sql = "SELECT module_name, module_description, module_url_base from ";
    $sql .= "scass_fes_modules where active = true and module_name != '' ";
    $sql .= "order by module_description";

    $result = pg_exec($database, $sql);


    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to select modules, database error: <tt>$message</tt>\n";
        return -1;
    }

    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "Failed to load module list: nothing found\n";
        return -1;
    }

    for ( $count = 0; $count < $rows; $count++ ) {
        $data = pg_fetch_object($result, $count);
        $module = $data->module_name;
        $modules[] = $module;
        $work = $data->module_url_base;
        $module_url[$module] = $work;
        $work = $data->module_description;
        $module_desc[$module] = $work;
    }

    if ( $current_module != '' ) {  // called with named module
// print tree and insert menu subtree at current_module
        $current_module_index = 0;
        $total_modules = count($modules);
        foreach ( $modules as $module ) {
            $current_module_index++;
            echo "<li><a href=\"$module_url[$module]\">";
            echo "$module_desc[$module]</a></li>\n";
            if ( $module == $current_module ) {  // print subtree
                $sql = "SELECT menu_name,menu_description,menu_url_base ";
                $sql .= "from scass_fes_menu where scass_fes_menu.module = ";
                $sql .= "(select id from scass_fes_modules where ";
                $sql .= "module_name = '$current_module') and active = true ";
                $sql .= "order by menu_description";
                $result = pg_exec($database, $sql);

                if ( $result == false ) {
                    $message = pg_errormessage($database);
                    echo "Failed to select menu, database error: ";
                    echo "<tt>$message</tt>\n";
                    return -1;
                }

// note: rows can be empty, this is valid!
                $rows = pg_numrows($result);

                echo "<ul>\n";
                $old_first = '';
                for ( $count = 0; $count < $rows; $count++ ) {
                    $data = pg_fetch_object($result, $count);
                    $menu_name = $data->menu_name;
                    $menu_description = $data->menu_description;
                    $menu_url_base = $data->menu_url_base;
                    preg_match("/\w+/", $menu_description, $matches);
                    $first = $matches[0];
                    if ( $old_first != '' ) { 
                        if ( $first != $old_first ) {
                            print "<br>\n";
                            $old_first = $first;
                        }
                    } else {
                        $old_first = $first;
                    }
                    echo "<li><a href=\"$menu_url_base\">";
                    echo "$menu_description</a></li>\n";
                }
                if ( $current_module_index < $total_modules ) {
                    echo "<br>\n";
                }
                echo"</ul>\n";
            }
        }
    } else { // no current module, list top level only
        foreach ( $modules as $module ) {
            print "<li><a href=\"$module_url[$module]\">";
            print "$module_desc[$module]</a></li>\n";
        }
    }


// print tail of this side 

    echo "</ul>\n";
    echo "</td>\n";
    echo "<td bgcolor=blue>&nbsp;</td>\n";
    echo "<td>\n";

    if ( $close_db == true ) {
        pg_close($database);
    }

    return(0);
}




?>
