<?php

// misc. text modules
// Author : Alexander Schreiber <als@thangorodrim.de>
// Version: $Id: textmodules.php,v 1.4 2002/07/20 00:08:35 sshcvs Exp $

function textmodule_hostname_style() {

    echo "By default, all hostnames are treated as relative names, that is, ";
    echo "the corresponding FQDN will be formed by appending the domain name ";
    echo "to the hostname. To specify absolute hostnames (for hosts outside ";
    echo "this domain), enter the hostname with a trailing dot: ";
    echo "<tt>\"hostname.\"</tt> instead of <tt>\"hostname\"</tt> - same as ";
    echo "in the BIND zone files.<br>\n";
}

function textmodule_modify_hint () {

    echo "Only records with the <tt>modify</tt> checkbox checked will be ";
    echo "updated upon <strong>commit</strong>, all other records will be ";
    echo "ignored.<br>\n";

}

function textmodule_database_login_failure () {

    echo "Database login failed, please try again with correct ";
    echo "authentication data. Use the <tt><b>back</b></tt> function of ";
    echo "your browser to return to the form.\n";

}

function textmodule_add_entry_hint ($add_count, $key_fields) {

    echo "You can add up to $add_count entries here. If you wish to enter ";
    echo "fewer entries, just leave the corresponding fields empty. Entries ";
    echo "with empty <strong>$key_fields</strong> field(s) are automatically ";
    echo "ignored and not added to the database.<br>\n";

}


function textmodule_db_action_summary ($action, $affected_count) {

    $done = 0;

    if ( $affected_count < 0 ) {
        echo "Imaginary number ($affected_count) of database records ";
        echo "$action. This reality is defective, please return it to ";
        echo "the manufacturer for repairs.\n<br>\n";
        $done++;
    }
    if ( $affected_count == 0 ) {
        echo "No database records where $action.\n<br>\n";
        $done++;
    }
    if ( $affected_count == 1 ) {
        echo "Sucessfully $action one database record.\n<br>\n";
        $done++;
    }
    if ( $affected_count > 1 ) {
        echo "Successfully $action $affected_count database records.\n<br>\n";
        $done++;
    }

}


?>
