<?php

// scass.fes - The frontendsystem of SCASS (System Configuration and
//             Administration Support System)
//
// Copyright (C) 2002  Alexander Schreiber <als@thangorodrim.de>
//
// This program is free software; you can redistribute it and/or modify 
// it under the terms of the GNU General Public License as published by 
// the Free Software Foundation; either version 2 of the License, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but 
// WITHOUT ANY WARRANTY; without even the implied warranty of  
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
// Public License for more details.


Header("Cache-Control: no-cache"); // avoid wrong form entries due to
                                   // caching

require("scass_dhcp_add.php");
require("scass_dhcp_show.php");
require("scass_dhcp_delete.php");
require("scass_dhcp_activate.php");
require("scass_dhcp_edit.php");

require("include/helpers.php");
require("include/db_helpers.php");
require("include/textmodules.php");
require("include/form_helper.php");

require("include/sidebar.php");

$current_module = 'dhcp_admin';
$database = public_db_signon();
$module_description = get_module_description($database, $current_module);

echo "<HTML>\n";
echo "<HEAD>\n";
echo "<title>SCASS - $module_description</title>\n";
echo "</HEAD>\n";
echo "<BODY>\n";

include("include/style.html");
display_sidebar_top($database, $current_module);

echo "<h1>$module_description</h1>\n";



// FIXME: verify all incoming data for validity!

// look for the job definition


if ( $HTTP_POST_VARS['job'] != '' ) {
    $job = $HTTP_POST_VARS['job'];
}

if ( $HTTP_GET_VARS['job'] != '' ) {
    $job = $HTTP_GET_VARS['job'];
}


switch ( $job ) {

    case 'simple_add_form_commit':
        if ( https_ok($_SERVER[HTTPS], 'simple_add_form_commit') ) {
            simple_add_form_commit($HTTP_POST_VARS);
        }
        break;

    case 'delete_from_simple_table_commit':
        if ( https_ok($_SERVER[HTTPS], 'delete from simple table commit') ) {
            delete_from_simple_table_commit($HTTP_POST_VARS);
        }
        break;

    case 'edit_simple_table_commit':
        if ( https_ok($_SERVER[HTTPS], 'edit simple table commit') ) {
            edit_simple_table_commit($HTTP_POST_VARS);
        }
        break;

    case 'show_net': 
        show_net();
    break;
    case 'show_host': 
        show_host();
    break;
    case 'show_range':
        show_range();
    break;

    case 'add_net':
        if ( https_ok($_SERVER[HTTPS], 'add new net') ) {
            add_net();
        }
    break;
    case 'add_net_commit': 
        if ( https_ok($_SERVER[HTTPS], 'add new net commit') ) {
            add_net_commit($HTTP_POST_VARS);
        }
    break;

    case 'add_host':
        if ( https_ok($_SERVER[HTTPS], 'add new host') ) {
            add_host(5);
        }
    break;
    case 'add_host_commit': 
        if ( https_ok($_SERVER[HTTPS], 'add new host commit') ) {
            add_host_commit($HTTP_POST_VARS);
        }
    break;
    case 'add_range':
        if ( https_ok($_SERVER[HTTPS], 'add new range') ) {
            add_range(1);  // more than at a time is unlikely
        }
    break;
    case 'add_range_commit':
        if ( https_ok($_SERVER[HTTPS], 'add new range commit') ) {
            add_range_commit($HTTP_POST_VARS);
        }
    break;

    case 'delete_net':
        if ( https_ok($_SERVER[HTTPS], 'delete net') ) {
            delete_net();
        }
    break;
    case 'delete_net_commit':
        if ( https_ok($_SERVER[HTTPS], 'delete net commit') ) { 
            delete_net_commit($HTTP_POST_VARS);
        }
    break;

    case 'delete_host':
        if ( https_ok($_SERVER[HTTPS], 'delete host') ) {
            delete_host();
        }
    break;
    case 'delete_host_commit': 
        if ( https_ok($_SERVER[HTTPS], 'delete host commit') ) {
            delete_host_commit($HTTP_POST_VARS);
        }
    break;

    case 'delete_range':
        if ( https_ok($_SERVER[HTTPS], 'delete range') ) {
            delete_range();
        }
    break;
    case 'delete_range_commit':
        if ( https_ok($_SERVER[HTTPS], 'delete range commit') ) {
            delete_range_commit($HTTP_POST_VARS);
        }
    break;


    case 'activate':
        if ( https_ok($_SERVER[HTTPS], 'activate') ) {
            activate();
        }
    break;
    case 'activate_commit':
        if ( https_ok($_SERVER[HTTPS], 'activate commit') ) {
            activate_commit($HTTP_POST_VARS);
        }
    break;

    case 'edit_net':
        if ( https_ok($_SERVER[HTTPS], 'edit net') ) {
            edit_net();
        }
    break;

    case 'edit_range':
        if ( https_ok($_SERVER[HTTPS], 'edit range') ) {
            edit_range();
        }
    break;

    case 'edit_range_commit':
        if ( https_ok($_SERVER[HTTPS], 'edit range commit') ) {
            edit_range_commit($HTTP_POST_VARS);
        }
    break;


    case 'edit_host':
        if ( https_ok($_SERVER[HTTPS], 'edit host') ) {
            edit_host();
        }
    break;

    case 'edit_host_commit':
        if ( https_ok($_SERVER[HTTPS], 'edit host commit') ) {
            edit_host_commit($HTTP_POST_VARS);
        }
    break;



    default: 
        if ( $job != '' ) {
            print_error("unhandled job: |$job|");
        }


    break;
}



?>

<?php
include("include/nav_sidebar_end.html");
?>



</BODY>
</HTML>


