<?php
// active_* handlers for the DHCP module
// author: Alexander Schreiber <als@thangorodrim.de>
// version: $Id: scass_dhcp_activate.php,v 1.2 2002/08/29 03:52:28 sshcvs Exp $
//


function activate () {

    $database = public_db_signon();

    $description = "activate DHCP changes";

    echo "<h1>$description</h2>\n";

    echo "<h2>DHCP networks pending commit</h2>\n";

    echo "List of DHCP networks which have been changed since the last";
    echo "commit and are already marked for commit:\n<br>\n";

    $sql = "SELECT net_name from dhcp_net where do_commit = true";
    $result = pg_exec($database, $sql);
    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "database query failed, database error: <tt>$result</tt><br>\n";
        return -1;
    }
    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "nothing found\n";
    } else {
        echo "<ul>\n";
        for ( $count = 0; $count < $rows; $count++ ) {
            $data = pg_fetch_object($result, $count);
            echo "<li>\n";
            echo "$data->net_name\n";
            echo "</li>\n";
        }
        echo "</ul>\n";
    }
    pg_freeresult($result);


    echo "<h2>DHCP networks needing commit</h2>\n";

    echo "List of DHCP networks which have been changed since the last ";
    echo "update, but don't have their commit flag set:\n<br>\n";


    $sql  = "SELECT n.net_name from dhcp_range r, dhcp_net n where ";
    $sql .= "(((n.last_commit < r.last_update) and (r.net = n.id)) and ";
    $sql .= "n.do_commit = false) union SELECT n.net_name from dhcp_host h, ";
    $sql .= "dhcp_net n where (((n.last_commit < h.last_update) and (h.net = ";
    $sql .= "n.id)) and n.do_commit = false)";

    $result = pg_exec($database, $sql);
    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "database query failed, database error: <tt>$result</tt><br>\n";
        return -1;
    }
    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "nothing found\n";
    } else {
        echo "<ul>\n";
        for ( $count = 0; $count < $rows; $count++ ) {
            $data = pg_fetch_object($result, $count);
            echo "<li>\n";
            echo "$data->net_name\n";
            $nets_needing_commit[] = $data->net_name;
            echo "</li>\n";
        }
        echo "</ul>\n";
    }
    pg_freeresult($result);

    $edit_count = count($nets_needing_commit);
    if ( $edit_count > 0 ) {
        foreach ( $nets_needing_commit as $net ) {
            echo "<form action=\"scass_dhcp.php\" method=\"POST\">\n";
        
            echo "<table>\n";
            echo "<thead>\n";
            echo "<th>commit</th><th>net_name</th>";
            echo "</thead>\n";
    
            for ( $count = 0; $count < $rows; $count++ ) {
                $print_count = $count + 1;
                echo "<tr>\n";
                echo "<td>";
                echo "<input type=\"checkbox\" name=\"commit_$count\"";
                echo " value=\"commit\" checked></td>\n";
                echo "<td>\n";
                echo "<input type=\"hidden\" name=\"net_name_$count\" ";
                echo "value=\"$net\">\n";
                echo "$net\n";
                echo "</td>\n";
        
            }
           
            echo "</table>\n"; 
     
        
            echo "<input type=\"hidden\" name=\"job\" ";
            echo "value=\"activate_commit\">\n";
            echo "<input type=\"hidden\" name=\"edit_count\" ";
            echo "value=\"$edit_count\">\n";
        
            print_db_auth_form();
        
            echo "<input type=\"submit\" value=\" commit \">\n";
            echo "<input type=\"reset\" value=\" clear \">\n";
        
            echo "</form>\n";
        }
    }

}



function activate_commit ($post) {

    echo "<h1>activate changes - commit</h1>\n";

    $database = db_signon($post['DB_USER'], $post['DB_PASSWORD']);
    if ( $database == -1 ) {
        textmodule_database_login_failure();

        return;
    }

    $records_updated = 0;

    for ( $count = 0; $count < $post[edit_count]; $count++ ) {
        $field = "commit_$count";
        if ( $post[$field] == "commit" ) {
            $field = "net_name_$count";
            $net_name = addslashes($post[$field]);
            $sql  = "UPDATE dhcp_net set do_commit = true where net_name = ";
            $sql .= "'$net_name'";
            $result = pg_exec($database, $sql);
            if ( $result == false ) {
                $message = pg_errormessage($database);
                echo "Failed to update dhcp_net record.\n";
                echo "Database error: <tt>$message</tt><br>\n";
            } else {
                $records_updated += pg_cmdtuples($result);
            }
        }
    }

    textmodule_db_action_summary("updated", $records_updated);

   
    pg_close($database); 












}















?>
