<?php
// add_* handlers for DHCP administration module
// author: Alexander Schreiber <als@thangorodrim.de>
// version: $Id: scass_dhcp_add.php,v 1.9 2002/08/30 14:20:10 sshcvs Exp $
//

function add_net () {

    $description = get_table_description(-1, 'dhcp_net');

    $fields = array('net_name' => 'network name',
                    'subnet_mask' => 'default subnet mask',
                    'default_lease_time' => 'default lease time (seconds)',
                    'max_lease_time' => 'max lease time (seconds)',
                    'ntp_servers' => 'NTP server list (comma separated)',
                    'routers' => 'router list (comma separated)',
                    'domain_name' => 'domain name',
                    'domain_name_server' => 
                                        'DNS server list (comma separated)',
                         'comment' => 'comment');

    $examples = array('net_name' => 'company_net',
                         'subnet_mask' => '255.255.255.0',
                         'default_lease_time' => '600',
                         'max_lease_time' => '7200',
                         'ntp_servers' => 'ntp.company.com,ntp.foo.org',
                         'routers' => 'gate.company.com',
                         'domain_name' => 'company.com',
                         'domain_name_server' => 
                                        'ns1.company.com,ns2.company.com',
                         'comment' => 'company network');

    $required_fields = array('net_name');
    $field_types = array('net_name' => 'line',
                         'subnet_mask' => 'line',
                         'default_lease_time' => 'line',
                         'max_lease_time' => 'line',
                         'ntp_servers' => 'line',
                         'routers' => 'line',
                         'domain_name' => 'line',
                         'domain_name_server' => 'line');
                        

//    simple_add_form($add_count, "add $description", 'dhcp_net', $data_fields,
//                    $example_fields, $required_fields, $field_types);

    $database = public_db_signon();
    $config_db = get_config_from_db($database);

    echo "<h2>add new DHCP network</h2>\n";

    echo "Add a new DHCP network entry here. DHCP networks are used to \n";
    echo "group DHCP ranges and host entries for the same physical or \n";
    echo "logical network together.\n<br>\n<br>\n";

    echo "<form action=\"scass_dhcp.php\" method=\"POST\">\n";
    echo "<table bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
    echo "<thead>\n";
    echo "<th>field</th><th>value</th><th>example</th>\n";
    echo "</thead>\n";

    $count = 0;
    foreach ( array_keys($fields) as $field ) { 
        $count++;
        print "<!-- field == |$field| -->\n";
        if ( $count % 2 == 0 ) {
            echo "<tr bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
        } else {
            echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
        }

        echo "<td>$fields[$field]</td>\n";
        $field_name = "${field}_0";
        echo "<td>\n";
        form_entry_text_line($field_name, '');
        echo "</td>\n";
        echo "<td>$examples[$field]</td>\n";
        echo "</tr>\n";

    }
    echo "</table>\n";

    print_db_auth_form();

    echo "<br>\n";

    hidden_form_entry('job', 'simple_add_form_commit');
    hidden_form_entry('add_count', 1);

    echo "<input type=\"submit\" value=\" commit \">\n";
    echo "<input type=\"reset\" value=\" clear \">\n";

    $count = 0;

    foreach ( array_keys($fields) as $field ) {
        $field_label = "data_field_";
        $field_label .= "$count";
        $count++;
        hidden_form_entry($field_label, $field);
    }

    hidden_form_entry('table', 'dhcp_net');
    $work = rawurlencode('add new DHCP network');
    hidden_form_entry(title, $work);
    $data_field_count = count($fields);
    hidden_form_entry('data_field_count', $data_field_count);
    hidden_form_entry('required_field_0', 'net_name');

    echo "</form>\n";

    pg_close($database);
}

function add_net_commit ($post) {
// empty, since it isn't needed - job is done by simple_add_form_commit()

}


function add_host($add_count) {

    $database = public_db_signon();
    $config_db = get_config_from_db($database);

    $description = get_menu_description($database, 'dhcp_admin', 
                                        'add_host');
    echo "<h1>$description</h2>\n";

    $net_names = get_column_from_table($database, 'dhcp_net', 'net_name', '');

    textmodule_add_entry_hint($add_count, 'hostname,ethernet,IP address');
    echo "<br>\n";

    echo "<form action=\"scass_dhcp.php\" method=\"POST\">\n";

    $dark_bg = $config_db[HTMLTableDarkRowBackground];
    $light_bg = $config_db[HTMLTableLightRowBackground];

    echo "<table bgcolor=\"$light_bg\">\n";
    echo "<thead>\n";
    echo "<th>entry</th><th>net_name</th><th>hostname</th>";
    echo "<th>ethernet</th><th>IP address</th>";
    echo "<th>comment</th>\n";
    echo "</thead>\n";
    for ( $count = 0; $count < $add_count; $count++ ) {
        if ( $count % 2 == 0 ) {
            echo "<tr bgcolor=\"$dark_bg\">\n";
        } else {
            echo "<tr bgcolor=\"$light_bg\">\n";
        }
        $show_count = $count + 1;
        echo "<td align=\"right\">$show_count</td>\n";
        echo "<td>\n";
        $label = "net_name_${count}";
        form_entry_select($label, $net_names);
        echo "</td>\n";
        echo "<td>\n";
        $label = "hostname_${count}";
        form_entry_short_text_line($label, '');
        echo "</td>\n"; 
        echo "<td>\n";
        $label = "ethernet_address_${count}";
        form_entry_short_text_line($label, '');
        echo "</td>\n";
        echo "<td>\n";
        $label = "fixed_address_${count}";
        form_entry_ip_line($label, '');
        echo "</td>\n";

        echo "<td>\n";
        $label = "comment_${count}";
        form_entry_short_text_line($label, '');
        echo "</td>\n";
        echo "</tr>\n";
    }

    echo "</table>\n";

    hidden_form_entry('job', 'add_host_commit');
    hidden_form_entry('add_count', $add_count);

    print_db_auth_form();

    echo "<input type=\"submit\" value=\" commit \">\n";
    echo "<input type=\"reset\" value=\" clear \">\n";

    echo "</form>\n";

    pg_close($database);
}

function add_host_commit ($post) {

    $database = public_db_signon();
    $config_db = get_config_from_db($database);

    $description = get_menu_description($database, 'dhcp_admin',
                                        'add_host');
    echo "<h1>$description - commit</h2>\n";

    pg_close($database);

    $add_count = $post[add_count];

    $database = db_signon($post[DB_USER], $post[DB_PASSWORD]);
    if ( $database == -1 ) {
        textmodule_database_login_failure();

        return;
    }

    $records_added = 0;

    for ( $count = 0; $count < $add_count; $count++ ) {
        $hostname = addslashes($post["hostname_${count}"]);
        $net_name = addslashes($post["net_name_${count}"]);
        $ethernet_address = addslashes($post["ethernet_address_${count}"]);
        $fixed_address = addslashes($post["fixed_address_${count}"]);
        $comment = addslashes($post["comment_${count}"]);


        if ( ( $hostname != '' ) and 
             ( $net_name != '' ) and
             ( $ethernet_address != '' ) and
             ( $fixed_address != '' ) ) {
            $sql  = "INSERT INTO dhcp_host (net,hostname,ethernet_address,";
            $sql .= "fixed_address,comment) values ((select id from dhcp_net";
            $sql .= " where net_name = '$net_name'), '$hostname', ";
            $sql .= "'$ethernet_address', '$fixed_address', '$comment')";

            $result = pg_exec($database, $sql);

            if ( $result == false ) {
                $message = pg_errormessage($database);
                echo "Failed to add host record.\n";
                echo "The database error message is: <tt>$message</tt>\n";
            } else {
                $records_added += pg_cmdtuples($result);
            }
        }
    }

    textmodule_db_action_summary('inserted', $records_added);

}


function add_range($add_count) {

    $database = public_db_signon();
    $config_db = get_config_from_db($database);

    $description = get_menu_description($database, 'dhcp_admin',
                                        'add_range');
    echo "<h1>$description</h2>\n";

    $net_names = get_column_from_table($database, 'dhcp_net', 'net_name', '');

    $software_name_count = count($software_names);
    $required = 'subnet, range_from, range_to, broadcast';
    textmodule_add_entry_hint($add_count, $required);
    echo "Entries with negative values for <strong>count</strong> are also ";
    echo "ignored.\n";
    echo "<br>\n<br>\n"; 

    echo "<form action=\"scass_dhcp.php\" method=\"POST\">\n";

    $dark_bg = $config_db[HTMLTableDarkRowBackground];
    $light_bg = $config_db[HTMLTableLightRowBackground];

    $fields = array('net_name' => 'network name',
                    'subnet' => 'subnet',
                    'range_from' => 'first IP',
                    'range_to' => 'last IP',
                    'routers' => 'router list',
                    'comment' => 'comment');

    $examples = array('net_name' => 'select from list',
                      'subnet' => '172.16.1.0/24',
                      'range_from' => '172.16.1.1',
                      'range_to' => '172.16.1.64',
                      'routers' => '172.16.1.254',
                      'comment' => 'visitor IPs');

    $types = array('net_name' => 'select',
                   'subnet' => 'ip_line',
                   'range_from' => 'ip_line',
                   'range_to' => 'ip_line',
                   'routers' => 'short_text_line',
                   'comment' => 'text_line');


    echo "<table>\n";
    for ( $count = 0; $count < $add_count; $count++ ) {
        echo "<tr>\n";
        if ( $add_count > 1 ) {
            $display_count = $count + 1;
            echo "<td><strong>${display_count}. range</strong></td>\n";
        }
        echo "<td>\n";
        echo "<table bgcolor=\"$light_bg\">\n";
        echo "<thead>\n";
        echo "<th>field</th><th>value</th><th>example</th>\n";
        echo "</thead>\n";
        $line_count = 0;
        foreach ( array_keys($fields) as $field ) {
            if ( $line_count % 2 == 0 ) {
                echo "<tr bgcolor=\"$dark_bg\">\n";
            } else {
                echo "<tr bgcolor=\"$light_bg\">\n";
            }
            $line_count++;
            echo "<td>$fields[$field]</td>\n";
            echo "<td>\n";
            $label = "${field}_${count}";
            if ( $types[$field] == 'ip_line' ) {
                form_entry_ip_line($label, '');
            }
            if ( $types[$field] == 'short_text_line' ) {
                form_entry_short_text_line($label, '');
            } 
            if ( $types[$field] == 'text_line' ) {
                form_entry_text_line($label, '');
            }
            if ( $field == 'net_name' ) {
                $net_names = get_column_from_table($database, 'dhcp_net',
                                                   'net_name', '');
                form_entry_select($label, $net_names);
            }

            echo "</td>\n";
            echo "<td>$examples[$field]</td>\n";

        }
        echo "</table>\n";
        echo "</td>\n";
        echo "</tr>\n";

    }

    echo "</table>\n";

    hidden_form_entry('job', 'add_range_commit');
    hidden_form_entry('add_count', $add_count);

    print_db_auth_form();

    echo "<input type=\"submit\" value=\" commit \">\n";
    echo "<input type=\"reset\" value=\" clear \">\n";

    echo "</form>\n";

    pg_close($database);

}


function add_range_commit ($post) {
    
    $database = public_db_signon();
    $config_db = get_config_from_db($database);

    $description = get_menu_description($database, 'dhcp_admin',
                                        'add_range');
    echo "<h1>$description - commit</h2>\n";
    
    pg_close($database);
    
    $add_count = $post[add_count];

    $database = db_signon($post[DB_USER], $post[DB_PASSWORD]);
    if ( $database == -1 ) {
        textmodule_database_login_failure();

        return;
    }

    $records_added = 0;

    for ( $count = 0; $count < $add_count; $count++ ) {
        $net_name = addslashes($post["net_name_${count}"]);
        $subnet = addslashes($post["subnet_${count}"]);
        $range_from = addslashes($post["range_from_${count}"]);
        $range_to = addslashes($post["range_to_${count}"]);
        $routers = addslashes($post["routers_${count}"]);

        $comment = addslashes($post["comment_${count}"]);


        if ( ( $subnet != '' ) and 
             ( $net_name != '' ) and
             ( $range_from != '' ) and
             ( $range_to != '' ) and
             ( $routers != '' ) ) {
            $sql  = "INSERT INTO dhcp_range (net,subnet,range_from,";
            $sql .= "range_to,routers,comment) values ";
            $sql .= "((select id from dhcp_net where net_name = ";
            $sql .= "'$net_name'), '$subnet', '$range_from', '$range_to', ";
            $sql .= "'$routers', '$comment')";

            $result = pg_exec($database, $sql);

            if ( $result == false ) {
                $message = pg_errormessage($database);
                echo "Failed to add range record.\n";
                echo "The database error message is: <tt>$message</tt>\n";
            } else {
                $records_added += pg_cmdtuples($result);
            }
        } else {
            echo "some required fields where empty!\n<b>\n";
        }
    }

    textmodule_db_action_summary('inserted', $records_added);

}



?>
