<?php
// the delete_* handlers for the DHCP management module
//
// version: $Id: scass_dhcp_delete.php,v 1.3 2002/08/30 01:05:11 sshcvs Exp $
// author: Alexander Schreiber <als@thangorodrim.de>
//

function delete_host () {

    $database = public_db_signon();
    $description = get_table_description($database, 'dhcp_host');
    $config_db = get_config_from_db($database);

    echo "<h1>delete $description</h1>\n";

    $sql  = "SELECT h.id,n.net_name,h.hostname,h.ethernet_address,";
    $sql .= "h.fixed_address,h.comment,h.last_update from dhcp_host h, ";
    $sql .= "dhcp_net n where n.id = h.net";

    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to select data, database error: <tt>$message</tt>\n";
        return -1;
    }

    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "Nothing found - no data inserted yet?\n";
        // an empty table is an unlikely, but still valid condition
        return 0;
    }

    $fields = array('net_name' => 'DHCP network',
                    'hostname' => 'hostname',
                    'ethernet_address' => 'ethernet address',
                    'fixed_address' => 'FQDN/IP-address',
                    'comment' =>'comment',
                    'last_update' => 'last updated');

    echo "<form action=\"scass_dhcp.php\" method=\"POST\">\n";

    show_delete_entry_table($result, $fields, $config_db);
    print_db_auth_form();

    echo "<br>\n";

    hidden_form_entry('job', 'delete_from_simple_table_commit');
    hidden_form_entry('delete_count', $rows);
    echo "<input type=\"submit\" value=\" commit \">\n";
    echo "<input type=\"reset\" value=\" clear \">\n";
    hidden_form_entry('table', 'dhcp_host');
    $work = rawurlencode("delete $description");
    hidden_form_entry(title, $work);

    echo "</form>\n";

    pg_close($database);

    return 0;
}


function delete_range () {

    $database = public_db_signon();
    $description = get_table_description($database, 'dhcp_range');
    $config_db = get_config_from_db($database);

    echo "<h1>delete $description</h1>\n";

    $sql  = "SELECT r.id, n.net_name, r.subnet, r.range_from, r.range_to, ";
    $sql .= "r.routers, r.comment, r.last_update from ";
    $sql .= "dhcp_net n, dhcp_range r where r.net = n.id";

    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to select data, database error: <tt>$message</tt>\n";
        return -1;
    }

    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "Nothing found - no data inserted yet?\n";
        // an empty table is an unlikely, but still valid condition
        return 0;
    }

    $fields = array('net_name' => 'DHCP network',
                    'subnet' => 'subnet',
                    'range_from' => 'first IP',
                    'range_to' => 'last IP',
                    'routers' => 'router list',
                    'comment' => 'comment');

    echo "<form action=\"scass_dhcp.php\" method=\"POST\">\n";

    show_delete_entry_table($result, $fields, $config_db);
    print_db_auth_form();

    echo "<br>\n";

    hidden_form_entry('job', 'delete_from_simple_table_commit');
    hidden_form_entry('delete_count', $rows);
    echo "<input type=\"submit\" value=\" commit \">\n";
    echo "<input type=\"reset\" value=\" clear \">\n";
    hidden_form_entry('table', 'dhcp_range');
    $work = rawurlencode("delete $description");
    hidden_form_entry(title, $work);

    echo "</form>\n";

    pg_close($database);

    return 0;
}


function delete_net () {

    $database = public_db_signon();
    $description = get_table_description($database, 'dhcp_net');
    $config_db = get_config_from_db($database);

    echo "<h1>delete $description</h1>\n";

    $sql  = "SELECT * from dhcp_net";

    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to select data, database error: <tt>$message</tt>\n";
        return -1;
    }

    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "Nothing found - no data inserted yet?\n";
        // an empty table is an unlikely, but still valid condition
        return 0;
    }

    $fields = array('net_name' => 'network name',
                    'subnet_mask' => 'default subnet mask',
                    'default_lease_time' => 'default lease time (seconds)',
                    'max_lease_time' => 'max lease time (seconds)',
                    'ntp_servers' => 'NTP server list (comma separated)',
                    'routers' => 'router list (comma separated)',
                    'domain_name' => 'domain name',
                    'domain_name_server' =>
                                        'DNS server list (comma separated)',
                         'comment' => 'comment');


    echo "<form action=\"scass_dhcp.php\" method=\"POST\">\n";

    show_delete_entry_table($result, $fields, $config_db);
    print_db_auth_form();

    echo "<br>\n";

    hidden_form_entry('job', 'delete_from_simple_table_commit');
    hidden_form_entry('delete_count', $rows);
    echo "<input type=\"submit\" value=\" commit \">\n";
    echo "<input type=\"reset\" value=\" clear \">\n";
    hidden_form_entry('table', 'dhcp_net');
    $work = rawurlencode("delete $description");
    hidden_form_entry(title, $work);

    echo "</form>\n";

    pg_close($database);

    return 0;
}




?>


