<?php
// the edit_* handlers for the DHCP module
// author: Alexander Schreiber <als@thangorodrim.de>
// version: $Id: scass_dhcp_edit.php,v 1.3 2002/08/30 14:20:10 sshcvs Exp $
//


function edit_net () {

    $description = get_table_description(-1, 'dhcp_net');

    $fields = array('net_name' => 'network name',
                    'subnet_mask' => 'default subnet mask',
                    'default_lease_time' => 'default lease time (seconds)',
                    'max_lease_time' => 'max lease time (seconds)',
                    'ntp_servers' => 'NTP server list (comma separated)',
                    'routers' => 'router list (comma separated)',
                    'domain_name' => 'domain name',
                    'domain_name_server' => 
                                        'DNS server list (comma separated)',
                         'comment' => 'comment');


    $field_types = array('net_name' => 'line',
                         'subnet_mask' => 'line',
                         'default_lease_time' => 'line',
                         'max_lease_time' => 'line',
                         'ntp_servers' => 'line',
                         'routers' => 'line',
                         'domain_name' => 'line',
                         'domain_name_server' => 'line');
                        

    edit_simple_table(-1, 'dhcp_net', $fields, $field_types,
                      'net_name', 'scass_dhcp.php');

}


function edit_host () {

    $database = public_db_signon();
    $config_db = get_config_from_db($database);

    $description = get_menu_description($database, 'dhcp_admin',
                                        'edit_dhcp_host');
    echo "<h1>$description</h2>\n";

    $net_names = get_column_from_table($database, 'dhcp_net', 'net_name', '');

    $sql  = "SELECT h.id, n.net_name, h.hostname, h.ethernet_address, ";
    $sql .= "h.fixed_address, h.comment from dhcp_host h, dhcp_net n where ";
    $sql .= "h.net = n.id";

    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to select data, database error: <tt>$message</tt>\n";
        return -1;
    }
    
    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "Nothing found - no data inserted yet?\n";
        // an empty table is an unlikely, but still valid condition
        return 0;
    }


    echo "<br>\n";

    echo "<form action=\"scass_dhcp.php\" method=\"POST\">\n";

    $dark_bg = $config_db[HTMLTableDarkRowBackground];
    $light_bg = $config_db[HTMLTableLightRowBackground];

    echo "<table bgcolor=\"$light_bg\">\n";
    echo "<thead>\n";
    echo "<th>entry</th><th>edit</th><th>net_name</th><th>hostname</th>";
    echo "<th>ethernet</th><th>IP address</th>";
    echo "<th>comment</th>\n";
    echo "</thead>\n";
    for ( $count = 0; $count < $rows; $count++ ) {
        $data = pg_fetch_object($result, $count);
        if ( $count % 2 == 0 ) {
            echo "<tr bgcolor=\"$dark_bg\">\n";
        } else {
            echo "<tr bgcolor=\"$light_bg\">\n";
        }
        $show_count = $count + 1;
        echo "<td align=\"right\">$show_count</td>\n";
        echo "<td align=\"center\">\n";
        $work = "_update_${count}";
        echo "<input type=\"checkbox\" name=\"$work\" value=\"true\">\n";
        echo"<br>old:\n";
        hidden_form_entry("id_${count}", $data->id);
        echo "</td>\n";
        echo "<td>\n";
        $label = "net_name_${count}";
        form_entry_select($label, $net_names);
        echo "<br>$data->net_name\n";
        echo "</td>\n";
        echo "<td>\n";
        $label = "hostname_${count}";
        form_entry_short_text_line($label, $data->hostname);
        echo "<br>$data->hostname\n";
        echo "</td>\n";
        echo "<td>\n";
        $label = "ethernet_address_${count}";
        form_entry_short_text_line($label, $data->ethernet_address);
        echo "<br>$data->ethernet_address\n";
        echo "</td>\n";
        echo "<td>\n";
        $label = "fixed_address_${count}";
        form_entry_ip_line($label, $data->fixed_address);
        echo "<br>$data->fixed_address\n";
        echo "</td>\n";

        echo "<td>\n";
        $label = "comment_${count}";
        form_entry_short_text_line($label, $data->comment);
        echo "<br>$data->comment\n";
        echo "</td>\n";
        echo "</tr>\n";
    }

    echo "</table>\n";

    hidden_form_entry('job', 'edit_host_commit');
    hidden_form_entry('update_count', $rows);

    print_db_auth_form();

    echo "<input type=\"submit\" value=\" commit \">\n";
    echo "<input type=\"reset\" value=\" clear \">\n";

    echo "</form>\n";

    pg_close($database);

}


function edit_host_commit ($post) {

    $database = public_db_signon();
    $config_db = get_config_from_db($database);

    $description = get_menu_description($database, 'dhcp_admin',
                                        'edit_dhcp_host');
    echo "<h1>$description - commit</h2>\n";

    $database = db_signon($post['DB_USER'], $post['DB_PASSWORD']);
    if ( $database == -1 ) {
        textmodule_database_login_failure();

        return;
    }

    $update_count = $post[update_count];

    $records_updated = 0;

    $fields = array('id', 'net_name', 'hostname', 'ethernet_address', 
                    'fixed_address', 'comment');

    for ( $count = 0; $count < $update_count; $count++ ) {
        $key = "_update_${count}";
        if ( $post[$key] == 'true' ) {
            foreach ( $fields as $field ) {
                $key = "${field}_${count}";
                $data = $post[$key];
                if ( $data == '' ) {
                    $$field = 'NULL';
                } else {
                    $data = addslashes($data);
                    $$field = "'$data'";
                }
            }

            $sql  = "UPDATE dhcp_host set net = (select id from dhcp_net ";
            $sql .= "where net_name = $net_name limit 1), hostname = ";
            $sql .= "$hostname, ethernet_address = $ethernet_address, ";
            $sql .= "fixed_address = $fixed_address, comment = $comment ";
            $sql .= "where id = $id";

            $result = pg_exec($database, $sql);
            if ( $result == false ) {
                $message = pg_errormessage($database);
                print_error("failed to update entry: $message");
            } else {
                $records_updated++;
            }
        }
    }

    textmodule_db_action_summary('updated', $records_updated);

    pg_close($database);

}


function edit_range () {

    $database = public_db_signon();
    $config_db = get_config_from_db($database);

    $description = get_menu_description($database, 'dhcp_admin',
                                        'edit_dhcp_range');
    echo "<h1>$description</h2>\n";

    $net_names = get_column_from_table($database, 'dhcp_net', 'net_name', '');

    $sql  = "SELECT r.id, n.net_name, r.subnet, r.range_from, r.range_to, ";
    $sql .= "r.routers, r.comment from dhcp_net n, dhcp_range r where ";
    $sql .= "r.net = n.id";

    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to select data, database error: <tt>$message</tt>\n";
        return -1;
    }
    
    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "Nothing found - no data inserted yet?\n";
        // an empty table is an unlikely, but still valid condition
        return 0;
    }


    echo "<br>\n";

    echo "<form action=\"scass_dhcp.php\" method=\"POST\">\n";

    $dark_bg = $config_db[HTMLTableDarkRowBackground];
    $light_bg = $config_db[HTMLTableLightRowBackground];

    echo "<table bgcolor=\"$light_bg\">\n";
    echo "<thead>\n";
    echo "<th>entry</th><th>edit</th><th>net_name</th><th>subnet</th>";
    echo "<th>first IP</th><th>last IP</th><th>routers</th>";
    echo "<th>comment</th>\n";
    echo "</thead>\n";
    for ( $count = 0; $count < $rows; $count++ ) {
        $data = pg_fetch_object($result, $count);
        if ( $count % 2 == 0 ) {
            echo "<tr bgcolor=\"$dark_bg\">\n";
        } else {
            echo "<tr bgcolor=\"$light_bg\">\n";
        }
        $show_count = $count + 1;
        echo "<td align=\"right\">$show_count</td>\n";
        echo "<td align=\"center\">\n";
        $work = "_update_${count}";
        echo "<input type=\"checkbox\" name=\"$work\" value=\"true\">\n";
        echo"<br>old:\n";
        hidden_form_entry("id_${count}", $data->id);
        echo "</td>\n";
        echo "<td>\n";
        $label = "net_name_${count}";
        form_entry_select($label, $net_names);
        echo "<br>$data->net_name\n";
        echo "</td>\n";
        echo "<td>\n";
        $label = "subnet_${count}";
        form_entry_short_text_line($label, $data->subnet);
        echo "<br>$data->subnet\n";
        echo "</td>\n";
        echo "<td>\n";
        $label = "range_from_${count}";
        form_entry_ip_line($label, $data->range_from);
        echo "<br>$data->range_from\n";
        echo "</td>\n";
        echo "<td>\n";
        $label = "range_to_${count}";
        form_entry_ip_line($label, $data->range_to);
        echo "<br>$data->range_to\n";
        echo "</td>\n";
        echo "<td>\n";
        $label = "routers_${count}";
        form_entry_text_line($label, $data->routers);
        echo "<br>$data->routers\n";
        echo "</td>\n";

        echo "<td>\n";
        $label = "comment_${count}";
        form_entry_short_text_line($label, $data->comment);
        echo "<br>$data->comment\n";
        echo "</td>\n";
        echo "</tr>\n";
    }

    echo "</table>\n";

    hidden_form_entry('job', 'edit_range_commit');
    hidden_form_entry('update_count', $rows);

    print_db_auth_form();

    echo "<input type=\"submit\" value=\" commit \">\n";
    echo "<input type=\"reset\" value=\" clear \">\n";

    echo "</form>\n";

    pg_close($database);

}



function edit_range_commit ($post) {

    $database = public_db_signon();
    $config_db = get_config_from_db($database);
    
    $description = get_menu_description($database, 'dhcp_admin',
                                        'edit_dhcp_range');
    echo "<h1>$description - commit</h2>\n";
    
    $database = db_signon($post['DB_USER'], $post['DB_PASSWORD']);
    if ( $database == -1 ) {
        textmodule_database_login_failure();

        return;
    }
    
    $update_count = $post[update_count];

    $records_updated = 0;

    $fields = array('id', 'net_name', 'subnet', 'range_from',
                    'range_to', 'routers', 'comment');

    for ( $count = 0; $count < $update_count; $count++ ) {
        $key = "_update_${count}";
        if ( $post[$key] == 'true' ) {
            foreach ( $fields as $field ) {
                $key = "${field}_${count}";
                $data = $post[$key];
                if ( $data == '' ) {
                    $$field = 'NULL';
                } else {
                    $data = addslashes($data);
                    $$field = "'$data'";
                }
            }

            $sql  = "UPDATE dhcp_range set net = (select id from dhcp_net ";
            $sql .= "where net_name = $net_name limit 1), subnet = ";
            $sql .= "$subnet, range_from = $range_from, ";
            $sql .= "range_to = $range_to, routers = $routers, comment = ";
            $sql .= "$comment where id = $id";

            $result = pg_exec($database, $sql);
            if ( $result == false ) {
                $message = pg_errormessage($database);
                print_error("failed to update entry: $message");
            } else {
                $records_updated++;
            }
        }
    }

    textmodule_db_action_summary('updated', $records_updated);

    pg_close($database);

}

