<?php
// show_* handlers for the DHCP admin module
// 
// version: $Id: scass_dhcp_show.php,v 1.6 2002/08/30 14:20:10 sshcvs Exp $
// author: Alexander Schreiber <als@thangorodrim.de>
//


function show_net() {

    $fields = array('net_name' => 'network name',
                    'subnet_mask' => 'default subnet mask',
                    'default_lease_time' => 'default lease time (seconds)',
                    'max_lease_time' => 'max lease time (seconds)',
                    'ntp_servers' => 'NTP server list (comma separated)',
                    'routers' => 'router list (comma separated)',
                    'domain_name' => 'domain name',
                    'domain_name_server' =>
                                        'DNS server list (comma separated)',
                         'comment' => 'comment');

    display_simple_table(-1, 'dhcp_net', $fields, 'net_name');

}


function show_host () {

    $fields = array('n.net_name' => 'DHCP network',
                    'h.hostname' => 'hostname',
                    'h.ethernet_address' => 'ethernet address',
                    'h.fixed_address' => 'IP address',
                    'h.comment' => 'comment',
                    'h.last_update' => 'last update');


    $tables = "dhcp_net n,dhcp_host h";
    $join_by = " h.net = n.id";
    display_joined_tables(-1, 'dhcp_host', $tables, $fields, $join_by, 
                          'h.hostname');


}


function show_range () {

    $fields = array('n.net_name' => 'DHCP network',
                    'r.subnet' => 'subnet',
                    'r.range_from' => 'first IP',
                    'r.range_to' => 'last IP',
                    'r.routers' => 'router list',
                    'r.comment' => 'comment');



    $tables = "dhcp_net n,dhcp_range r";
    $join_by = " r.net = n.id";
    display_joined_tables(-1, 'dhcp_range', $tables, $fields, $join_by,
                          'r.range_from');

}











?>
