<?php

// scass.fes - The frontendsystem of SCASS (System Configuration and
//             Administration Support System)
//
// Copyright (C) 2002  Alexander Schreiber <als@thangorodrim.de>
//
// This program is free software; you can redistribute it and/or modify 
// it under the terms of the GNU General Public License as published by 
// the Free Software Foundation; either version 2 of the License, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but 
// WITHOUT ANY WARRANTY; without even the implied warranty of  
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
// Public License for more details.


Header("Cache-Control: no-cache"); // avoid wrong form entries due to
                                   // caching
require("scass_dns_select_zone.php");
require("scass_dns_show_zone.php");
require("scass_dns_edit_zone.php");
require("scass_dns_add_zone.php");
require("scass_dns_activate.php");
require("scass_dns_delete_entries.php");

require("include/helpers.php");
require("include/db_helpers.php");
require("include/textmodules.php");
require("include/form_helper.php");

require("include/sidebar.php");

$current_module = 'dns_admin';
$database = public_db_signon();
$module_description = get_module_description($database, $current_module);

echo "<HTML>\n";
echo "<HEAD>\n";
echo "<title>SCASS - $module_description</title>\n";
echo "</HEAD>\n";
echo "<BODY>\n";

include("include/style.html");
display_sidebar_top($database, $current_module);

echo "<h1>$module_description</h1>\n";



// FIXME: verify all incoming data for validity!

// look for the job definition


if ( $HTTP_POST_VARS['job'] != '' ) {
    $job = $HTTP_POST_VARS['job'];
}

if ( $HTTP_GET_VARS['job'] != '' ) {
    $job = $HTTP_GET_VARS['job'];
}

if ( $HTTP_POST_VARS['zone_id'] != '' ) {
    $zone_id = $HTTP_POST_VARS['zone_id'];
}

if ( $HTTP_GET_VARS['zone_id'] != '' ) {
    $zone_id = $HTTP_GET_VARS['zone_id'];
}

if ( $HTTP_POST_VARS['add_count'] != '' ) {
    $add_count = $HTTP_POST_VARS['add_count'];
}

if ( $HTTP_GET_VARS['add_count'] != '' ) {
    $add_count = $HTTP_GET_VARS['add_count'];
}

switch ( $job ) {
    case 'select_show': 
        select_zone('show');
    break;
    case 'select_edit': 
        select_zone('edit');
    break;
    case 'show':
        show_zone($zone_id);
    break;
    case 'add_zone':
        if ( https_ok($_SERVER[HTTPS], 'add new zone') ) {
            add_zone();
        }
    break;
    case 'add_zone_commit': 
        if ( https_ok($_SERVER[HTTPS], 'add new zone commit') ) {
            add_zone_commit($HTTP_POST_VARS);
        }
    break;
    case 'add_A_records':
        if ( https_ok($_SERVER[HTTPS], 'add new A records') ) {
            add_A_records($zone_id, $add_count);
        }
    break;
    case 'add_A_records_commit':
        if ( https_ok($_SERVER[HTTPS], 'add new A records commit') ) {
            add_A_records_commit($HTTP_POST_VARS);
        }
    break;
    case 'add_alias_records':
        if ( https_ok($_SERVER[HTTPS], 'add new alias records') ) {
            add_alias_records($zone_id, $add_count);
        }
    break;
    case 'add_alias_records_commit':
        if ( https_ok($_SERVER[HTTPS], 'add new alias records commit') ) {
            add_alias_records_commit($HTTP_POST_VARS);
        }
    break;
    case 'edit_alias_records':
        if ( https_ok($_SERVER[HTTPS], 'edit alias records') ) {
            edit_alias_records($zone_id);
        }
    break;
    case 'edit_alias_records_commit':
        if ( https_ok($_SERVER[HTTPS], 'edit alias records commit') ) {
            edit_alias_records_commit($HTTP_POST_VARS);
        }
    break;
    case 'edit_A_records':
        if ( https_ok($_SERVER[HTTPS], 'edit A records') ) {
            edit_A_records($zone_id);
        }
    break;
    case 'edit_A_records_commit':
        if ( https_ok($_SERVER[HTTPS], 'edit A records commit') ) {
            edit_A_records_commit($HTTP_POST_VARS);
        }
    break;
    case 'edit_zone':
        if ( https_ok($_SERVER[HTTPS], 'edit zone') ) {
            edit_zone($zone_id);
        }
    break;
    case 'edit_zone_commit':
        if ( https_ok($_SERVER[HTTPS], 'edit zone commit') ) {
            edit_zone_commit($HTTP_POST_VARS);
        }
    break;
    case 'activate':
        if ( https_ok($_SERVER[HTTPS], 'activate') ) {
            activate();
        }
    break;
    case 'activate_commit':
        if ( https_ok($_SERVER[HTTPS], 'activate commit') ) {
            activate_commit($HTTP_POST_VARS);
        }
    break;
    case 'delete_alias_records':
        if ( https_ok($_SERVER[HTTPS], 'delete alias records') ) {
            delete_alias_records($zone_id, $add_count);
        }
    break;
    case 'delete_alias_records_commit':
        if ( https_ok($_SERVER[HTTPS], 'delete alias records commit') ) {
            delete_alias_records_commit($HTTP_POST_VARS);
        }
    break;
    case 'delete_A_records':
        if ( https_ok($_SERVER[HTTPS], 'delete A records') ) {
            delete_A_records($zone_id);
        }
    break;
    case 'delete_A_records_commit':
        if ( https_ok($_SERVER[HTTPS], 'delete A records commit') ) {
            delete_A_records_commit($HTTP_POST_VARS);
        }
    break;  
    case 'delete_zone':
        if ( https_ok($_SERVER[HTTPS], 'delete zone') ) {
            delete_zone($zone_id);
        }
    break;
    case 'delete_zone_commit':
        if ( https_ok($_SERVER[HTTPS], 'delete zone commit') ) {
            delete_zone_commit($HTTP_POST_VARS);
        }
    break;


    
    default:        
    break;
}



?>

<?php
include("include/nav_sidebar_end.html");
?>



</BODY>
</HTML>
