<?php

// version: $Id: scass_dns_activate.php,v 1.6 2002/06/21 00:49:19 sshcvs Exp $


function activate () {

    echo "<h1>Activate changes</h1>\n";

    echo "This will set the commit flag on all modified zones, causing those ";
    echo "changes to be committed to the DNS server upon the next commit ";
    echo "run.<br>\n";

    $database = public_db_signon();

// select zones pending commit, defined as do_commit = true
    echo "<h2>Zones pending commit:</h2>\n";

    $sql = "SELECT id,zone_name,domain from dns_zone where do_commit = true";
    $result = pg_exec($database, $sql);
    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "database query failed, database error: <tt>$result</tt><br>\n";
        return -1;
    }
    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "nothing found\n";
    } else {
        echo "<ul>\n";
        for ( $count = 0; $count < $rows; $count++ ) {
            $data = pg_fetch_object($result, $count);
            echo "<li>\n";
            echo "$data->domain ($data->zone_name)\n";
            echo "</li>\n";
        }
        echo "</ul>\n";
    }
    pg_freeresult($result);


// select zones which need commit, this is defined as (pseudocode):
//   time_stamp(last_change(ANY_ENTRY_IN_ZONE)) > last_commit
//   and do_commit = false

    echo "<h2>Zones needing commit:</h2>\n";

    $sql = "SELECT DISTINCT z.id, z.zone_name, z.last_commit, z.last_update ";
    $sql .= "from dns_zone z, dns_alias a, dns_mapping m, dns_special s ";
    $sql .= "where  ((z.last_update > z.last_commit) or (a.last_update > ";
    $sql .= "z.last_commit) or (m.last_update > z.last_commit) or ";
    $sql .= "(s.last_update > z.last_commit)) and (z.do_commit != true)";


//    $sql = "SELECT id,zone_name,domain from dns_zone where ";
//    $sql .= "last_update > last_commit  and do_commit != true";
    $result = pg_exec($database, $sql);
    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "database query failed, database error: <tt>$result</tt><br>\n";
        return -1;
    }
    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "nothing found\n";
    } else {
        echo "<ul>\n";
        for ( $count = 0; $count < $rows; $count++ ) {
            $data = pg_fetch_object($result, $count);
            echo "<li>\n";
            echo "$data->domain ($data->zone_name)\n";
            $id = $data->id;
            $needs_commit[$id] = 1;
            echo "</li>\n";
        }
        echo "</ul>\n";
    }

    if ( count($needs_commit) ) {
        $sql = "SELECT id,domain,zone_name from dns_zone where ";
        $first = 1;
        foreach ( array_keys($needs_commit) as $key ) {
            if ( $first == 1 ) {
                $sql .= " id = $key ";
                $first = 0;
            } else {
                $sql .= " or id = $key ";
            }
        }
        $sql .= " order by domain";
    
//        echo "sql = <tt>|$sql|</tt><br>\n";
    
        $result = pg_exec($database, $sql);
        if ( $result == false ) {
            $message = pg_errormessage($database);
            echo "database query failed, database error: <tt>$result</tt><br>\n";
            return -1;
        }
        $rows = pg_numrows($result);
        if ( $rows == 0 ) {
            echo "<li>nothing found - somebody deleted the zones?</li>\n";
        } else {
    
            $edit_count = $rows;
            echo "<form action=\"scass_dns.php\" method=\"POST\">\n";
        
            echo "<table>\n";
            echo "<thead>\n";
            echo "<th>commit</th><th>domain</th><th>zone name</th>";
            echo "</thead>\n";
       
    
            for ( $count = 0; $count < $rows; $count++ ) {
                $data = pg_fetch_object($result, $count);
                $print_count = $count + 1;
                echo "<tr>\n";
                echo "<td>";
                echo "<input type=\"checkbox\" name=\"commit_$count\"";
                echo " value=\"commit\" checked></td>\n";
                echo "<td>\n";
                echo "<input type=\"hidden\" name=\"id_$count\" ";
                echo "value=\"$data->id\">\n";
                echo "$data->domain\n";
                echo "</td>\n";
                echo "<td>$data->zone_name</td>\n";
                echo "<td>\n";
        
            }
           
            echo "</table>\n"; 
     
        
            echo "<input type=\"hidden\" name=\"job\" ";
            echo "value=\"activate_commit\">\n";
            echo "<input type=\"hidden\" name=\"edit_count\" ";
            echo "value=\"$edit_count\">\n";
        
            print_db_auth_form();
        
            echo "<input type=\"submit\" value=\" commit \">\n";
            echo "<input type=\"reset\" value=\" clear \">\n";
        
            echo "</form>\n";
    
        }
    
        pg_close($database);
    }
}


function activate_commit ($post) {

    echo "<h1>activate changes - commit</h1>\n";

    $database = db_signon($post['DB_USER'], $post['DB_PASSWORD']);
    if ( $database == -1 ) {
        textmodule_database_login_failure();

        return;
    }

    $records_updated = 0;

    for ( $count = 0; $count < $post[edit_count]; $count++ ) {
        $field = "commit_$count";
        if ( $post[$field] == "commit" ) {
            $field = "id_$count";
            $zone_id = $post[$field];
            $sql = "UPDATE dns_zone set do_commit = true where id = $zone_id";
//          echo "sql = <tt>|$sql|</tt><br>\n";
            $result = pg_exec($database, $sql);
            if ( $result == false ) {
                $message = pg_errormessage($database);
                echo "Failed to update zone record.\n";
                echo "Database error: <tt>$message</tt><br>\n";
            } else {
                $records_updated += pg_cmdtuples($result);
            }
        }
    }

    if ( $records_updated == 0 ) {
        echo "No zone records updated.\n";
    } else {
        if ( $records_updated == 1 ) {
            echo "Successfully updated 1 zone record.\n";
        } else {
            echo "Successfully updated $records_updated zone records.\n";
        }
    }
   
    pg_close($database); 

}




?>
