<?php


function add_zone () {

    $special_count = 8;

    $database = public_db_signon();
    $config_db = get_config_from_db($database);

    echo "<h1>add new zone</h1>";

    echo "With the exception of <tt>comment</tt>, which can remain empty, ";
    echo "<strong>all</strong> fields need to be filled with the ";
    echo "appropriate values.";

    echo "<h2>zone information</h2>\n";

    echo "<form action=\"scass_dns.php\" method=\"POST\">\n";
    echo "<table bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
    echo "<thead>\n";
    echo "<th>field</th><th>value</th><th>example</th>\n";
    echo "</thead>\n";

    $fields = array("zone_name", "domain", "primary_ns", "network",
                    "refresh", "retry", "expire", "minimum", "zone_admin",
                    "comment");

    $examples = array ("zone_name" => "our_company", 
                       "domain" => "company.com",
                       "primary_ns" => "ns.company.com",
                       "network" => "10.1.2",
                       "refresh" => "28800",
                       "retry" => "7200",   
                       "expire" => "604800",
                       "minimum" => "86400",
                       "zone_admin" => "admin@company.com",
                       "comment" => "some describing words");

    $field_count = count($fields);

    for ( $count = 0; $count < $field_count; $count++ ) {
        $field = $fields[$count];
//        echo "<tr>";
        if ( $count % 2 == 1 ) {
            echo "<tr bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
        } else {
            echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
        }

        echo "<td>$fields[$count]</td>\n";
        echo "<td><input name=\"$field\" type=\"text\" size=\"30\"></td>\n";
        echo "<td>$examples[$field]</td>\n";
        echo "</tr>\n";

    }
    echo "</table>\n";

    $sql = "select type from dns_special_types";
    $result = pg_exec($database, $sql);
    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to load DNS special records data.<br>\n";
        echo "Database error message: <tt>$message</tt><br>\n";
    } else {
        $rows = pg_numrows($result);
        if ( $rows == 0 ) {
            echo "No DNS special record types found.<br>\n";
        } else {
            for ( $count = 0; $count < $rows; $count++ ) {
                $data = pg_fetch_object($result, $count);
                $types[] = $data->type;
            }


            echo "<h2>DNS special records for this zone</h2>\n";
            echo "Enter the special DNS records (like MX, NS) for the zone ";
            echo "here. Needed fields are <strong>type</strong> and ";
            echo "<strong>value</strong>, the others are optional. Entries ";
            echo "with empty <strong>value</strong> fields are ignored.<br>\n";
            echo "<br>\n";
            echo "<table ";
            echo "bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
            echo "<thead>\n";
            echo "<th></th>";  // spacer
            echo "<th>type</th><th>weight</th><th>value</th>";
            echo "<th>comment</th>\n";
            echo "</thead>\n";
            echo "<tr>\n";
            echo "<td>example</td><td>MX</td><td>100</td>";
            echo "<td>mx.domain.com</td><td>central mail hub</td>\n";
            echo "</tr>\n";

            for ( $count = 0; $count < $special_count; $count++ ) {
                if ( $count % 2 == 1 ) {
                    echo "<tr bgcolor=\"";
                    echo "$config_db[HTMLTableLightRowBackground]\">\n";
                } else {
                    echo "<tr bgcolor=\"";
                    echo "$config_db[HTMLTableDarkRowBackground]\">\n";
                }
                echo "<td>&nbsp;</td>\n";
                echo "<td>\n";
                echo "<select name=\"type_$count\" size=\"1\">\n";
                foreach ( $types as $type ) {
                    echo "<option>$type</option>\n";
                }
                echo "</select>\n";
                echo "</td>\n";
                echo "<td>\n";
                echo "<input type=\"text\" name=\"weight_$count\" ";
                echo "size=\"4\">\n";
                echo "</td>\n";
                echo "<td>\n";
                echo "<input type=\"text\" name=\"value_$count\" ";
                echo "size=\"20\">\n";
                echo "</td>\n";
                echo "<td>\n";
                echo "<input type=\"text\" name=\"comment_$count\" ";
                echo "size=\"20\">\n";
                echo "</td>\n";

                echo "</tr>\n";
            }
            echo "</table>\n";
            echo "<input type=\"hidden\" name=\"special_count\" ";
            echo "value=\"$special_count\">\n";
        }
    }

    print_db_auth_form();

    echo "<br>\n";

    echo "<input type=\"hidden\" name=\"job\" value=\"add_zone_commit\">\n";

    echo "<input type=\"submit\" value=\" commit \">\n";
    echo "<input type=\"reset\" value=\" clear \">\n";

    echo "</form>\n";


}


function add_zone_commit ($post) {

    echo "<h1>add new zone - commit</h1>\n";

    $database = db_signon($post[DB_USER], $post[DB_PASSWORD]);
    if ( $database == -1 ) {
        textmodule_database_login_failure();

        return;
    }

    $result = pg_exec($database, "BEGIN WORK"); // start transaction
    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to start transaction.<br>\n";
        echo "Database error message: <tt>$message</tt><br>\n";
        return;
    }

    $fields = array('zone_name', 'domain', "primary_ns", "network",
                    'refresh', 'retry', 'expire', 'minimum', 'zone_admin', 
                    'comment');

    $last_field = $fields[(count($fields) - 1)];
    $sql = "insert into dns_zone (";
    foreach ( $fields as $field ) {
        $sql .= " $field";
        if ( $field != $last_field ) {
            $sql .= ", ";
        }
    }
    $sql .= ") values (";

    foreach ( $fields as $field ) {
        $value = $post[$field];
# check for possibly troubling characters as we go
        if ( $value == '' ) {  // check for empty value and set them to NULL
            $sql .= "NULL";
        } else {
            $value = addslashes($value);
            $sql .= "'$value'";
        }
        if ( $field != $last_field ) {
            $sql .= ", ";
        }
    }

    $sql .= ")";

    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to add zone.\n";
        if ( preg_match("/Fail to add null value in not null/", $message) ) {
            echo "One or more mandatory fields were left empty.<br>\n";
        }
        if ( preg_match("/pg_atoi: error in/", $message) ) {
            echo "Non-numeric characters in numeric field.<br>\n";
        }

        echo "The database error message is: <tt>$message</tt>\n";
    }

// now start entering the special records
    $special_count = $post['special_count'];

    for ( $count = 0; $count < $special_count; $count++ ) {
        $field = "type_$count";
        $type = addslashes($post[$field]);
        $field = "weight_$count";
        $weight = addslashes($post[$field]);
        $field = "value_$count";
        $value = addslashes($post[$field]);
        $field = "comment_$count";
        $comment = addslashes($post[$field]);

        if ( $weight == '' ) {
            $weight = 0;
        }

        if ( ( $type != '' ) and ( $value != '' ) ) { // skip empty entries
            $sql = "INSERT INTO dns_special (type, weight, zone, value, ";
            $sql .= "comment) values ((select id from dns_special_types where";
            $sql .= " type = '$type'), $weight, (select id from dns_zone ";
            $sql .= "where zone_name = '$post[zone_name]'), '$value', ";
            $sql .= "'$comment')";

//            echo "sql = <tt>|$sql|</tt><br>\n";
            $result = pg_exec($database, $sql);
            if ( $result == false ) {
                $message = pg_errormessage($database);
                echo "Failed to add DNS special record.<br>\n";
                echo "Database error message: <tt>$message</tt>\n";
                $result = pg_exec($database, "ROLLBACK WORK");
                if ( $result == false ) { // hopefully _that_ never happens
                    $message = pg_errormessage($database);
                    echo "Failed to rollback transaction.<br>\n";
                    echo "Database error message: <tt>$message</tt><br>\n";
                }
                return;
            }
        }
    }

    $result = pg_exec($database, "COMMIT WORK");
    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to commit transaction.<br>\n";
        echo "Database error message: <tt>$message</tt><br>\n";
        $result = pg_exec($database, "ROLLBACK WORK");
        if ( $result == false ) { // hopefully _that_ never happens
            $message = pg_errormessage($database);
            echo "Failed to rollback transaction.<br>\n";
            echo "Database error message: <tt>$message</tt><br>\n";
        }
        return;
    }

    pg_close($database);

// if we got this far, everything worked

    echo "Zone data added successfully.\n";

}


function add_A_records ($zone_id, $add_count) {

    $database = public_db_signon();
    $config_db = get_config_from_db($database);

    echo "<h1>add A records</h1>\n";

    print_short_zone_header($zone_id);

    echo "You can add up to $add_count hostnames here. If you wish to add ";
    echo "fewer hosts, just leave the corresponding fields empty. Host ";
    echo "entries where either the <strong>ip</strong> or the ";
    echo "<strong>hostname</strong> field are empty are automatically ";
    echo "ignored.<br>\n";

    textmodule_hostname_style();
    echo "<br>\n";
    
    $fields = array('ip', 'hostname', 'txt', 'hinfo', 'comment');
    
    echo "<form action=\"scass_dns.php\" method=\"POST\">\n";
    echo "<table bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";

    echo "<thead>\n";
    echo "<th>entry</th>\n";
    foreach ($fields as $field_name ) {
        echo "<th>$field_name</th>\n";
    }
    echo "</thead>\n";

    for ( $count = 0; $count < $add_count; $count++ ) {
        if ( $count % 2 == 1 ) {
            echo "<tr bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
        } else {
            echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
        }

        $print_count = $count + 1;
        echo "<td>$print_count</td>\n";
        foreach ( $fields as $field_name) {
            echo "<td>\n";
            $print_name = sprintf("%s_%s", $field_name, $count);
            echo "<input type=\"text\" name=\"$print_name\" size=\"12\">\n";
            echo "</td>\n";
        }
        echo "</tr>\n";
    }

    echo "</table>\n";

    print_db_auth_form();

    echo "<input type=\"hidden\" name=\"job\" value=\"add_A_records_commit\">\n";
    echo "<input type=\"hidden\" name=\"zone_id\" value=\"$zone_id\">\n";
    echo "<input type=\"hidden\" name=\"add_count\" value=\"$add_count\">\n";

    echo "<input type=\"submit\" value=\" commit \">\n";
    echo "<input type=\"reset\" value=\" clear \">\n";

    echo "</form>\n";

    pg_close($database);
}


function add_A_records_commit ($post) {

    echo "<h1>add new A records - commit</h1>\n";

    $database = db_signon($post['DB_USER'], $post['DB_PASSWORD']);
    if ( $database == -1 ) {
        textmodule_database_login_failure();

        return;
    }

    $fields = array('ip', 'hostname', 'txt', 'hinfo', 'comment');
    $last_field = $fields[(count($fields) - 1)];

    $records_added = 0;

    for ( $count = 0; $count < $post[add_count]; $count++ ) {
    
        $last_field = $fields[(count($fields) - 1)];
        $sql = "insert into dns_mapping (zone, ";
        foreach ( $fields as $field ) {
            $sql .= " $field";
            if ( $field != $last_field ) {
                $sql .= ", ";
            }
        }
        $sql .= ") values ($post[zone_id], ";
    
        foreach ( $fields as $field ) {
            $post_field = "$field";
            $post_field .= "_$count";
            $value = $post[$post_field];
            if ( $value == '' ) { // check for empty value and set them to NULL
                $sql .= "NULL";
            } else {
                $value = addslashes($value);
                $sql .= "'$value'";
            }
            if ( $field != $last_field ) {
                $sql .= ", ";
            }
        }
    
        $sql .= ")";
    
        if ( ( $post["ip_$count"] == '' ) or 
             ( $post["hostname_$count"] == '' ) ) {
            continue; // skip DB insert upon this one
        }

        $result = pg_exec($database, $sql);
    
        if ( $result == false ) {
            $message = pg_errormessage($database);
            echo "Failed to add A record.\n";
            if ( preg_match("/Fail to add null value in not null/", $message)){
                echo "One or more mandatory fields were left empty.<br>\n";
            }
            if ( preg_match("/pg_atoi: error in/", $message) ) {
                echo "Non-numeric characters in numeric field.<br>\n";
            }
    
            echo "The database error message is: <tt>$message</tt>\n";
        } else {
            $records_added += pg_cmdtuples($result);
        }
    } 

    echo "Successfully added $records_added A record entries.<br>\n";
}


function add_alias_records ($zone_id, $add_count) {

    echo "<h1>add alias records</h1>\n";
    print_short_zone_header($zone_id);

    $database = public_db_signon();
    $config_db = get_config_from_db($database);

    echo "You can add up to $add_count alias records here. If you wish to ";
    echo "add fewer alias entries, just leave the corresponding fields empty.";
    echo " Alias entries where the <strong>name</strong> field is empty are";
    echo " automatically ignored.<br>";

    textmodule_hostname_style();
    echo "<br>\n";

    $sql = "SELECT hostname from dns_mapping where zone = (select id from dns_zone where id=$zone_id limit 1) group by hostname order by hostname";
    $result = pg_exec($database, $sql);
    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to load zone information, database error: $message<br>";
        return -1;
    }

    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "Found no hostnames in zone, might be a zone without A records?";
        echo "<br>\n";
        return -1;
    }

    for ( $count = 0; $count < $rows; $count++ ) {
        $data = pg_fetch_object($result, $count);
        $hostnames[$count] = $data->hostname;
    }
    pg_freeresult($result);


    echo "<form action=\"scass_dns.php\" method=\"POST\">\n";
    echo "<table bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
    echo "<thead>\n";
    echo "<th>entry</th><th>name</th><th>target</th><th>comment</th>\n";
    echo "</thead>\n";

    for ( $count = 0; $count < $add_count; $count++ ) {
        $print_count = $count + 1;
        if ( $count % 2 == 1 ) {
            echo "<tr bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
        } else {
            echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
        }
        echo "<td>$print_count</td>\n";
        echo "<td>";
        echo "<input type=\"text\" name=\"name_$count\" size=\"12\">";
        echo "</td>\n";
        echo "<td>\n";
        echo "<select name=\"target_$count\"> size=\"5\">\n";
        foreach ( $hostnames as $hostname ) {
            echo "<option>$hostname</option>\n";
        }
        echo "</select>\n";
        echo "</td>\n";
        echo "<td>\n";
        echo "<input type=\"text\" name=\"comment_$count\" size=\"12\">";
        echo "</td>\n";
        echo "</tr>\n";
    }

    echo "</table>\n";

    print_db_auth_form();

    echo "<br>\n";

    echo "<input type=\"hidden\" name=\"job\" ";
    echo "value=\"add_alias_records_commit\">\n";
    echo "<input type=\"hidden\" name=\"add_count\" ";
    echo "value=\"$add_count\">\n";
    echo "<input type=\"hidden\" name=\"zone_id\" ";
    echo "value=\"$zone_id\">\n";

    echo "<input type=\"submit\" value=\" commit \">\n";
    echo "<input type=\"reset\" value=\" clear \">\n";

    echo "</form>\n";
    
    pg_close($database);
}


function add_alias_records_commit ($post) {

    echo "<h1>add alias records - commit</h1>\n";

    $database = db_signon($post['DB_USER'], $post['DB_PASSWORD']);
    if ( $database == -1 ) {
        textmodule_database_login_failure();

        return;
    }


    $fields = array('name', 'target', 'comment');
    $last_field = $fields[(count($fields) - 1)];

    $records_added = 0;
    for ( $count = 0; $count < $post[add_count]; $count++ ) {

        $last_field = $fields[(count($fields) - 1)];
        $sql = "insert into dns_alias (zone, ";
        foreach ( $fields as $field ) {
            $sql .= " $field";
            if ( $field != $last_field ) {
                $sql .= ", ";
            }
        }
        $sql .= ") values ($post[zone_id], ";

        foreach ( $fields as $field ) {
            $post_field = "$field";
            $post_field .= "_$count";
            $value = $post[$post_field];
            if ( $value == '' ) { // check for empty value and set them to NULL
                $sql .= "NULL";
            } else {
                $value = addslashes($value);
#                $sql .= "'$value'";
                if ( $field == 'target' ) {
                    $sql .= " (select id from dns_mapping where ";
                    $sql .= "hostname='$value' and zone = $post[zone_id] ";
                    $sql .= "limit 1) ";
                } else {
                    $sql .= "'$value'";
                }
            }
            if ( $field != $last_field ) {
                $sql .= ", ";
            }
        }

        $sql .= ")";

        if (  $post["name_$count"] == '' ) { 
            continue; // skip DB insert upon this one
        }

#        echo "sql = <tt>|$sql|</tt><br>\n";
#        continue;

        $result = pg_exec($database, $sql);

        if ( $result == false ) {
            $message = pg_errormessage($database);
            echo "Failed to add alias record.\n";
            if ( preg_match("/Fail to add null value in not null/", $message)){
                echo "One or more mandatory fields were left empty.<br>\n";
            }
            if ( preg_match("/pg_atoi: error in/", $message) ) {
                echo "Non-numeric characters in numeric field.<br>\n";
            }

            echo "The database error message is: <tt>$message</tt>\n";
        } else {
            $records_added += pg_cmdtuples($result);
        }
   }

    if ( $records_added == 1 ) {
        echo "Successfully added $records_added alias record.<br>\n";
    }
    if ( $records_added > 1 ) {
        echo "Successfully added $records_added alias records.<br>\n";
    }
    if ( $records_added == 0 ) {
        echo "No alias records added.<br>\n";
    }


}



?>
