<?php
// version: $Id: scass_dns_delete_entries.php,v 1.7 2002/07/13 18:57:10 sshcvs Exp $

function delete_alias_records($zone_id) {



    echo "<h1>delete alias records</h1>\n";
    print_short_zone_header($zone_id);

    $database = public_db_signon();

    $config_db = get_config_from_db($database);

    $sql =  "SELECT a.id, a.name,m.hostname,a.comment from dns_alias a, ";
    $sql .= "dns_mapping m where ( a.zone=$zone_id and a.target = m.id)";
    $sql .= " order by name";
    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to select alias data.<br>\n";
        echo "Database error message: $message<br>\n";
        return;
    }

    $rows = pg_numrows($result);
    $delete_count = $rows;
    $edit_count = $rows;
    if ( $rows == 0 ) {
        echo "No alias data found!<br>\n";
        return;
    }


    echo "<form action=\"scass_dns.php\" method=\"POST\">\n";

    echo "<table  bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
    echo "<thead>\n";
    echo "<th>delete</th><th>name</th><th>target</th>";
    echo "<th>comment</th>\n";
    echo "</thead>\n";

    for ( $count = 0; $count < $rows; $count++ ) {
        $data = pg_fetch_object($result, $count);
        $print_count = $count + 1;
        if ( $count % 2 == 1 ) {
            echo "<tr bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
        } else {
            echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
        }
        echo "<td>";
        echo "<input type=\"checkbox\" name=\"delete_$count\"";
        echo " value=\"delete\" unchecked></td>\n";
        echo "<td>\n";
        echo "<input type=\"hidden\" name=\"id_$count\" ";
        echo "value=\"$data->id\">\n";
        echo "$data->name";
        echo "</td>\n";
        echo "<td>$data->hostname</td>\n";

        echo "</td>\n";
        echo "<td>";
        echo "$data->comment";
        echo "</tr>\n";

    }

    echo "</table>\n";


    echo "<input type=\"hidden\" name=\"job\" ";
    echo "value=\"delete_alias_records_commit\">\n";
    echo "<input type=\"hidden\" name=\"delete_count\" ";
    echo "value=\"$delete_count\">\n";
    echo "<input type=\"hidden\" name=\"zone_id\" ";
    echo "value=\"$zone_id\">\n";

    print_db_auth_form();

    echo "<input type=\"submit\" value=\" commit \">\n";
    echo "<input type=\"reset\" value=\" clear \">\n";

    echo "</form>\n";

    pg_close($database);


}


function delete_alias_records_commit ($post) {

    echo "<h1>delete alias records - commit</h1>\n";
    print_short_zone_header($post[zone_id]);

    $database = db_signon($post['DB_USER'], $post['DB_PASSWORD']);
    if ( $database == -1 ) {
        textmodule_database_login_failure();

        return;
    }


    $records_deleted = 0;

    for ( $count = 0; $count < $post[delete_count]; $count++ ) {
        $field = "delete_$count";
        if ( $post[$field] == "delete" ) {
            $field = "id_$count";
            $sql = "DELETE from dns_alias where id = $post[$field] ";
            $sql .= "and zone = $post[zone_id]";
//            echo "sql = <tt>|$sql|</tt><br>\n";
            $result = pg_exec($database, $sql);
            if ( $result == false ) {
                $message = pg_errormessage($database);
                echo "Failed to delete alias record.\n";
                echo "Database error message: <tt>$message</tt><br>\n";
            } else {
                $records_deleted += pg_cmdtuples($result);
            }
        }

    }

    if ( $records_deleted == 1 ) {
        echo "Successfully deleted $records_deleted alias record.<br>\n";
    }
    if ( $records_deleted > 1 ) {
        echo "Successfully deleted $records_added alias records.<br>\n";
    }
    if ( $records_deleted == 0 ) {
        echo "No alias records deleted.<br>\n";
    }

    pg_close($database);

}



function delete_A_records ($zone_id) {

    echo "<h1>delete A records</h1>\n";
    print_short_zone_header($zone_id);
    
    $database = public_db_signon();
    $config_db = get_config_from_db($database);

    $sql = "SELECT id,hostname,ip,txt,hinfo,comment from dns_mapping where ";
    $sql .= "zone = $zone_id";

    
    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to select A record data.<br>\n";
        echo "Database error message: $message<br>\n";
        return;
    }

    $rows = pg_numrows($result);
    $delete_count = $rows;
    $edit_count = $rows;
    if ( $rows == 0 ) {
        echo "No A record data found!<br>\n";
        return;
    }


    echo "<form action=\"scass_dns.php\" method=\"POST\">\n";

    echo "<table bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
    echo "<thead>\n";
    echo "<th>delete</th><th>hostname</th><th>ip</th>";
    echo "<th>hinfo</th><th>txt</th><th>comment</th>\n";
    echo "</thead>\n";

    for ( $count = 0; $count < $rows; $count++ ) {
        $data = pg_fetch_object($result, $count);
        $print_count = $count + 1;
        if ( $count % 2 == 1 ) {
            echo "<tr bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
        } else {
            echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
        }
        echo "<td>";
        echo "<input type=\"checkbox\" name=\"delete_$count\"";
        echo " value=\"delete\" unchecked></td>\n";
        echo "<td>\n";
        echo "<input type=\"hidden\" name=\"id_$count\" ";
        echo "value=\"$data->id\">\n";
        echo "$data->hostname";
        echo "</td>\n";
        echo "<td>$data->ip</td>\n";
        echo "<td>$data->hinfo</td>\n";
        echo "<td>$data->txt</td>\n";
        echo "<td>";
        echo "$data->comment";
        echo "</tr>\n";

    }

    echo "</table>\n";


    echo "<input type=\"hidden\" name=\"job\" ";
    echo "value=\"delete_A_records_commit\">\n";
    echo "<input type=\"hidden\" name=\"delete_count\" ";
    echo "value=\"$delete_count\">\n";
    echo "<input type=\"hidden\" name=\"zone_id\" ";
    echo "value=\"$zone_id\">\n";

    print_db_auth_form();

    echo "<input type=\"submit\" value=\" commit \">\n";
    echo "<input type=\"reset\" value=\" clear \">\n";

    echo "</form>\n";

    pg_close($database);

}


function delete_A_records_commit ($post) {


    echo "<h1>delete A records - commit</h1>\n";
    print_short_zone_header($post[zone_id]);

    $database = db_signon($post['DB_USER'], $post['DB_PASSWORD']);
    if ( $database == -1 ) {
        textmodule_database_login_failure();

        return;
    }


    $records_deleted = 0;

    for ( $count = 0; $count < $post[delete_count]; $count++ ) {
        $field = "delete_$count";
        if ( $post[$field] == "delete" ) {
            $field = "id_$count";
            $id = $post[$field];
            $sql = "DELETE from dns_mapping where id = $id ";
            $sql .= "and zone = $post[zone_id]";
//            echo "sql = <tt>|$sql|</tt><br>\n";
            $result = pg_exec($database, $sql);
            if ( $result == false ) {
                $message = pg_errormessage($database);
                echo "Failed to delete A record.\n";
                echo "Database error message: <tt>$message</tt><br>\n";
                if (preg_match("/referential integrity violation/",$message)) {
                    if (preg_match("/from dns_alias/",$message)) {
                        echo "<h4>Error - A record still pointed to by \n";
                        echo "alias record, matching alias records:</h4>\n";
                        display_dns_alias_table($database, "dns_mapping.id = $id");
                        echo "<br><br>\n";
                    }
                }
            } else {
                $records_deleted += pg_cmdtuples($result);
            }
        }

    }

    if ( $records_deleted == 1 ) {
        echo "Successfully deleted $records_deleted A record.<br>\n";
    }
    if ( $records_deleted > 1 ) {
        echo "Successfully deleted $records_deleted A records.<br>\n";
    }
    if ( $records_deleted == 0 ) {
        echo "No A records deleted.<br>\n";
    }

    pg_close($database);

}


function delete_zone ($zone_id) {

    echo "<h1>delete zone</h1>\n";

    if ( !preg_match("/^\d+$/", $zone_id ) ) {
        print_error("argument error, zone_id must be numerical");
        return -1;
    }


    print_short_zone_header($zone_id);

    $database = public_db_signon();
    $config_db = get_config_from_db($database);

    
    echo "<form action=\"scass_dns.php\" method=\"POST\">\n";

    print_db_auth_form();

    form_submit_buttons();

    echo "<input type=\"hidden\" name=\"job\" ";
    echo "value=\"delete_zone_commit\">\n";
    echo "<input type=\"hidden\" name=\"zone_id\" ";
    echo "value=\"$zone_id\">\n";

    echo "</form>\n";

}



function delete_zone_commit ($post) {


    echo "<h1>delete zone - commit</h1>\n";

    if ( !preg_match("/^\d+$/", $post[zone_id] ) ) {
        print_error("argument error, zone_id must be numerical");
        return -1;
    }


    print_short_zone_header($post[zone_id]);

    $database = db_signon($post['DB_USER'], $post['DB_PASSWORD']);

    if ( $database == -1 ) {
        textmodule_database_login_failure();

        return;
    }

    $sql = "delete from dns_zone where id = $post[zone_id]";

    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to delete zone record, database error message is: ";
        echo "<tt>$message</tt><br>\n";
        $work = "key in dns_zone still referenced from dns_mapping";
        if ( preg_match("/$work/", $message) ) {
            echo "Matching DNS A records : <br>\n";
            display_dns_mapping_table($database, 
                                      "dns_mapping.zone = $post[zone_id]");
        }
        $work = "key in dns_zone still referenced from dns_alias";
        if ( preg_match("/$work/", $message) ) {
            echo "Matching DNS alias records: <br><br>\n";
            display_dns_alias_table($database, "dns_zone.id = $post[zone_id]");
        }

    } else {
        echo "Successfully delete zone record.<br>\n";
    }

    pg_close($database);

}







?>
