<?php

function edit_alias_records($zone_id) {


    echo "<h1>edit alias records</h1>\n";
    print_short_zone_header($zone_id);

    $database = public_db_signon();
    $config_db = get_config_from_db($database);

    $result = pg_exec($database, "BEGIN WORK");
    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Transaction failure, database error: $message<br>\n";
        $result = pg_exec($database, "ROLLBACK");
        return;
    }

    $sql = "SELECT hostname from dns_mapping where zone = (select id from dns_zone where id=$zone_id limit 1) group by hostname order by hostname";
    $result = pg_exec($database, $sql);
    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to load zone information, database error: $message<br>";
        return -1;
    }

    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "Found no hostnames in zone, might be a zone without alias";
        echo " records?";
        echo "<br>\n";
        return -1;
    }

    for ( $count = 0; $count < $rows; $count++ ) {
        $data = pg_fetch_object($result, $count);
        $hostnames[$count] = $data->hostname;
    }
    pg_freeresult($result);

    $sql =  "SELECT a.id, a.name,m.hostname,a.comment from dns_alias a, ";
    $sql .= "dns_mapping m where ( a.zone=$zone_id and a.target = m.id)";
    $sql .= " order by name";
    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to select alias data.<br>\n";
        echo "Database error message: $message<br>\n";
        $result = pg_exec($database, "ROLLBACK");
        return;
    }

    $rows = pg_numrows($result);
    $edit_count = $rows;
    if ( $rows == 0 ) {
        echo "No alias data found!<br>\n";
        return;
    }

    textmodule_modify_hint();
    textmodule_hostname_style();
    
    echo "<br>\n";

    echo "<form action=\"scass_dns.php\" method=\"POST\">\n";

    echo "<table bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
    echo "<thead>\n";
    echo "<th>modify</th><th>name</th><th>old target</th><th>new target</th>";
    echo "<th>comment</th>\n";
    echo "</thead>\n";

    for ( $count = 0; $count < $rows; $count++ ) {
        $data = pg_fetch_object($result, $count);
        $print_count = $count + 1;
        if ( $count % 2 == 1 ) {
            echo "<tr bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
        } else {
            echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
        }
        echo "<td>";
        echo "<input type=\"checkbox\" name=\"modify_$count\"";
        echo " value=\"modify\" unchecked></td>\n";
        echo "<td>\n";
        echo "<input type=\"hidden\" name=\"id_$count\" ";
        echo "value=\"$data->id\">\n";
        echo "<input type=\"text\" name=\"name_$count\"";
        echo " value=\"$data->name\" size=\"20\">";
        echo "</td>\n";
        echo "<td>$data->hostname</td>\n";
        echo "<td>\n";

        echo "<select name=\"target_$count\"> size=\"5\"";
        echo " value=\"$$data->hostname\">\n";
        foreach ( $hostnames as $hostname ) {
            echo "<option>$hostname</option>\n";
        }
        echo "</select>\n";

        echo "</td>\n";
        echo "<td><input type=\"text\" name=\"comment_$count\"";
        echo " value=\"$data->comment\" size=\"20\"></td>\n";
        echo "</tr>\n";

    }

    echo "</table>\n";


    echo "<input type=\"hidden\" name=\"job\" ";
    echo "value=\"edit_alias_records_commit\">\n";
    echo "<input type=\"hidden\" name=\"edit_count\" ";
    echo "value=\"$edit_count\">\n";
    echo "<input type=\"hidden\" name=\"zone_id\" ";
    echo "value=\"$zone_id\">\n";

    print_db_auth_form();

    echo "<input type=\"submit\" value=\" commit \">\n";
    echo "<input type=\"reset\" value=\" clear \">\n";

    echo "</form>\n";

    $result = pg_exec($database, "COMMIT");
    pg_close($database);

}


function edit_alias_records_commit ($post) {

    echo "<h1>edit alias records - commit</h1>\n";
    print_short_zone_header($post[zone_id]);

    $database = db_signon($post['DB_USER'], $post['DB_PASSWORD']);
    if ( $database == -1 ) {
        textmodule_database_login_failure();

        return;
    }   

    $fields = array('name', 'target', 'comment');
    $last_field = $fields[(count($fields) - 1)];

    $records_added = 0;
    for ( $count = 0; $count < $post[edit_count]; $count++ ) {
        $field = "modify_$count";
        if ( $post[$field] == 'modify' ) { // anything to do?
            $last_field = $fields[(count($fields) - 1)];
            $sql = "update dns_alias set ";
    
            foreach ( $fields as $field ) {
                $post_field = "$field";
                $post_field .= "_$count";
                $value = $post[$post_field];
                if ( $value == '' ) { // check for empty value and set them to NULL
                    $sql .= "NULL";
                } else {
                    $value = addslashes($value);
                    if ( $field == 'target' ) {
                        $sql .= " target = ";
                        $sql .= " (select id from dns_mapping where ";
                        $sql .= "hostname='$value' and zone = $post[zone_id] ";
                        $sql .= "limit 1) ";
                    } else {
                        $sql .= "$field = '$value'";
                    }
                }
                if ( $field != $last_field ) {
                    $sql .= ", ";
                }
            }
            $field = "id_$count";
            $sql .= " where id = $post[$field] and zone = $post[zone_id]";   
#            echo "sql = <tt>|$sql|</tt><br>\n";
    
            $result = pg_exec($database, $sql);
    
            if ( $result == false ) {
                $message = pg_errormessage($database);
                echo "Failed to update alias record.\n";
                if ( preg_match("/Fail to add null value in not null/", $message)){
                    echo "One or more mandatory fields were left empty.<br>\n";
                }
                if ( preg_match("/pg_atoi: error in/", $message) ) {
                    echo "Non-numeric characters in numeric field.<br>\n";
                }
    
                echo "The database error message is: <tt>$message</tt>\n";
            } else {
                $records_added += pg_cmdtuples($result);
            }
        }
    }

    if ( $records_added == 1 ) {
        echo "Successfully updated $records_added alias record.<br>\n";
    }
    if ( $records_added > 1 ) {
        echo "Successfully updated $records_added alias records.<br>\n";
    }
    if ( $records_added == 0 ) {
        echo "No alias records updated.<br>\n";
    }


    pg_close($database);



}


function edit_A_records ($zone_id) {

    echo "<h1>edit A records</h1>\n";
    print_short_zone_header($zone_id);

    $database = public_db_signon();
    $config_db = get_config_from_db($database);

    $sql = "SELECT id,ip,hostname,txt,hinfo,comment from dns_mapping ";
    $sql .= " where zone = $zone_id order by hostname,ip";

    $result = pg_exec($database, $sql);
    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to load zone information, database error: $message<br>";
        return -1;
    }

    $rows = pg_numrows($result);
    $edit_count = $rows;
    if ( $rows == 0 ) {
        echo "Found no hostnames in zone, might be a zone without A records?";
        echo "<br>\n";
        return -1;
    }

    textmodule_modify_hint();
    textmodule_hostname_style();
    echo "<br>\n";

    echo "<form action=\"scass_dns.php\" method=\"POST\">\n";

    echo "<table bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
    echo "<thead>\n";
    echo "<th>modify</th><th>hostname</th><th>IP address</th><th>txt</th>";
    echo "<th>hinfo</th><th>comment</th>\n";
    echo "</thead>\n";

    $fields = array('hostname', 'ip', 'txt', 'hinfo', 'comment');

    for ( $count = 0; $count < $rows; $count++ ) {
        $data = pg_fetch_object($result, $count);
        if ( $count % 2 == 1 ) {
            echo "<tr bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
        } else {
            echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
        }
        echo "<td>";
        echo "<input type=\"checkbox\" name=\"modify_$count\"";
        echo " value=\"modify\" unchecked></td>\n";
        echo "<td>\n";
        echo "<input type=\"hidden\" name=\"id_$count\" ";
        echo "value=\"$data->id\">\n";
        echo "<input type=\"text\" name=\"hostname_$count\"";
        echo " value=\"$data->hostname\" size=\"16\">";
        echo "</td>\n";
        echo "<td>\n";
        echo "<input type=\"text\" name=\"ip_$count\"";
        echo " value=\"$data->ip\" size=\"15\">";
        echo "</td>\n";
        echo "<td>\n";
        echo "<input type=\"text\" name=\"txt_$count\"";
        echo " value=\"$data->txt\" size=\"16\">";
        echo "</td>\n";
        echo "<td>\n";
        echo "<input type=\"text\" name=\"hinfo_$count\"";
        echo " value=\"$data->hinfo\" size=\"8\">";
        echo "</td>\n";
        echo "<td>\n";
        echo "<input type=\"text\" name=\"comment_$count\"";
        echo " value=\"$data->comment\" size=\"20\">";
        echo "</td>\n";


        echo "</tr>\n";
    }

    echo "</table>\n";


    echo "<input type=\"hidden\" name=\"job\" ";
    echo "value=\"edit_A_records_commit\">\n";
    echo "<input type=\"hidden\" name=\"edit_count\" ";
    echo "value=\"$edit_count\">\n";
    echo "<input type=\"hidden\" name=\"zone_id\" ";
    echo "value=\"$zone_id\">\n";

    print_db_auth_form();

    echo "<input type=\"submit\" value=\" commit \">\n";
    echo "<input type=\"reset\" value=\" clear \">\n";

    echo "</form>\n";

    pg_close($database);
}


function edit_A_records_commit($post) {

    echo "<h1>edit alias records - commit</h1>\n";
    print_short_zone_header($post[zone_id]);
    
    $database = db_signon($post['DB_USER'], $post['DB_PASSWORD']);
    if ( $database == -1 ) {
        textmodule_database_login_failure();

        return;
    }

    $fields = array('ip', 'hostname', 'txt', 'hinfo', 'comment');
    $last_field = $fields[(count($fields) - 1)];

    $records_added = 0;

    for ( $count = 0; $count < $post[edit_count]; $count++ ) {
        $post_field = "modify_$count";
        if ( $post[$post_field] != 'modify' ) { 
            continue; // ignore records that are not to be modified
        }
        $last_field = $fields[(count($fields) - 1)];
        $sql = "update dns_mapping set ";

// some pre-checks - the DB checks these too, of course, but we'll check
// for these here to give the user some useful error messages
        $post_field = "ip_$count";
        if ( $post[$post_field] == '' ) {
            echo "<strong>error:</strong> Please fill in an IP address.";
            echo "</br>\n";
            continue;
        }
        $post_field = "hostname_$count";
        if ( $post[$post_field] == '' ) {
            echo "<strong>error:</strong> Please fill in a hostname.";
            echo "</br>\n";
            continue;
        }

        foreach ( $fields as $field ) {
            $post_field = "$field";
            $post_field .= "_$count";
            $value = $post[$post_field];
            $sql .= " $field = ";
            if ( $value == '' ) { // check for empty value and set them to NULL
                $sql .= "NULL";
            } else {
                $value = addslashes($value);
                $sql .= "'$value'";
            }
            if ( $field != $last_field ) {
                $sql .= ", ";
            }
        }

        $post_field = "id_$count";
        $sql .= " where id = $post[$post_field] and zone = $post[zone_id]";

        if ( ( $post["ip_$count"] == '' ) or
             ( $post["hostname_$count"] == '' ) ) {
            continue; // skip DB insert upon this one
        }

#        echo "sql = <tt>|$sql|</tt><br>\n";
        $result = pg_exec($database, $sql);

        if ( $result == false ) {
            $message = pg_errormessage($database);
            echo "Failed to update A record.\n";
            if ( preg_match("/Fail to add null value in not null/", $message)){
                echo "One or more mandatory fields were left empty.<br>\n";
            }
            if ( preg_match("/pg_atoi: error in/", $message) ) {
                echo "Non-numeric characters in numeric field.<br>\n";
            }

            echo "The database error message is: <tt>$message</tt>\n";
        } else {
            $records_added += pg_cmdtuples($result);
        }
    }

    if ( $records_added == 1 ) {
        echo "Successfully updated $records_added A record.<br>\n";
    }
    if ( $records_added > 1 ) {
        echo "Successfully updated $records_added A records.<br>\n";
    }
    if ( $records_added == 0 ) {
        echo "No A records updated.<br>\n";
    }


    pg_close($database);

}


function edit_zone ($zone_id) {

    echo "<h1>edit zone</h1>\n";
    print_short_zone_header($zone_id);

    $database = public_db_signon();
    $config_db = get_config_from_db($database);

    $sql = "select zone_name,domain,primary_ns,network,serial,refresh,retry,";
    $sql .= "expire,minimum,zone_admin,comment,last_update from ";
    $sql .= "dns_zone where id = $zone_id";
    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "database query failed, database error: <tt>$result</tt><br>\n";
        return -1;
    }

    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "Found no zone with this zone_id - maybe stale query?<br>\n";
        return -1;
    }
    if ( $rows > 1 ) {
        echo "More than one result found, database is fucked up.<br>\n";
        return -1;
    }

    $data = pg_fetch_object($result, $count);


    echo "<form action=\"scass_dns.php\" method=\"POST\">\n";
    echo "<h3>Zone data for this zone</h3>\n";
    echo "<table bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
    echo "<thead>\n";
    echo "<th>field</th><th>old value</th><th>new value</th>\n";
    echo "</thead>\n";

    echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
    echo "<td>last update</td><td>$data->last_update</td>\n";
    echo "<td>updated by database</td>\n";
    echo "</tr>\n";

    echo "<tr>\n";
    echo "<td>domain name</td><td>$data->domain</td>\n";
    echo "<td><input type=\"text\" name=\"domain\" size=\"20\" ";
    echo "value=\"$data->domain\"></td>\n";
    echo "</tr>\n";

    echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
    echo "<td>zone name</td><td>$data->zone_name &nbsp</td>\n";
    echo "<td><input type=\"text\" name=\"zone_name\" size=\"20\" ";
    echo "value=\"$data->zone_name\"></td>\n";
    echo "</tr>\n";

    echo "<tr>\n";
    echo "<td>zone name</td><td>$data->primary_ns &nbsp</td>\n";
    echo "<td><input type=\"text\" name=\"primary_ns\" size=\"20\" ";
    echo "value=\"$data->primary_ns\"></td>\n";
    echo "</tr>\n";
    
    echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
    echo "<td>network</td><td>$data->network &nbsp</td>\n";
    echo "<td><input type=\"text\" name=\"network\" size=\"20\" ";
    echo "value=\"$data->network\"></td>\n";
    echo "</tr>\n";

    echo "<tr>\n";
    echo "<td>zone name</td><td>$data->zone_admin &nbsp</td>\n";
    echo "<td><input type=\"text\" name=\"zone_admin\" size=\"20\" ";
    echo "value=\"$data->zone_admin\"></td>\n";
    echo "</tr>\n";

    echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
    echo "<td>serial</td><td>$data->serial &nbsp</td>\n";
    echo "<td>not editable</td>\n";
    echo "</tr>\n";

    echo "<tr>\n";
    echo "<td>comment</td><td>$data->comment &nbsp</td>\n";
    echo "<td><input type=\"text\" name=\"comment\" size=\"20\" ";
    echo "value=\"$data->comment\"></td>\n";
    echo "</tr>\n";

    echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
    echo "<td>refresh</td><td>$data->refresh seconds</td>\n";
    echo "<td><input type=\"text\" name=\"refresh\" size=\"20\" ";
    echo "value=\"$data->refresh\"></td>\n";
    echo "</tr>\n";

    echo "<tr>\n";
    echo "<td>retry</td><td>$data->retry seconds</td>\n";
    echo "<td><input type=\"text\" name=\"retry\" size=\"20\" ";
    echo "value=\"$data->retry\"></td>\n";
    echo "</tr>\n";

    echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
    echo "<td>expire</td><td>$data->expire seconds</td>\n";
    echo "<td><input type=\"text\" name=\"expire\" size=\"20\" ";
    echo "value=\"$data->expire\"></td>\n";
    echo "</tr>\n";

    echo "<tr>\n";
    echo "<td>SOA minimum</td><td>$data->minimum seconds</td>\n";
    echo "<td><input type=\"text\" name=\"minimum\" size=\"20\" ";
    echo "value=\"$data->minimum\"></td>\n";
    echo "</tr>\n";

    echo "</table>\n";

// DNS special records

    $special_count = 8;

    $sql = "select type from dns_special_types";
    $result = pg_exec($database, $sql);
    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to load DNS special records data.<br>\n";
        echo "Database error message: <tt>$message</tt><br>\n";
    } else {
        $rows = pg_numrows($result);
        if ( $rows == 0 ) {
            echo "No DNS special record types found.<br>\n";
        } else {
            for ( $count = 0; $count < $rows; $count++ ) {
                $data = pg_fetch_object($result, $count);
                $types[] = $data->type;
            }
        }
    }
    pg_freeresult($result);


    $sql = "SELECT s.id, t.type, s.weight, s.value, s.comment from ";
    $sql .= "dns_special_types t, dns_special s where ( zone = $zone_id ) ";
    $sql .= "and t.id = s.type";
    $result = pg_exec($database, $sql);
    if ( $result == false ) {
        $error = pg_errormessage($database);
        echo "Failed to load DNS special records.<br>\n";
        echo "Database error message: <tt>$message</tt><br>\n";
        return;
    }
    $rows = pg_numrows($result);
    $special_actions = array('update', 'delete', 'keep');
    if ( $rows == 0 ) {
        echo "No DNS special records found for this zone.<br>\n";
        $old_count = 0;
    } else {
        echo "<h3>Existing DNS special records for this zone</h3>\n";
        echo "<table bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
        echo "<thead>\n";
        echo "<th>update</th><th>delete</th><th>keep</th>";
        echo "<th>type</th><th>weight</th><th>value</th>";
        echo "<th>comment</th>\n";
        echo "</thead>\n";
        for ( $count = 0; $count < $rows; $count++ ) {
            $data = pg_fetch_object ($result, $count);
            echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";

            echo "<td><strong>old value:</strong></td>\n";
            $first = 1;
            foreach ( $special_actions as $special_action ) {
                if ( $first == 0 ) {
                    echo "<td>\n";
                    echo "&nbsp;";
                    echo "</td>\n";
                } else {
                    $first = 0;
                    echo "<input type=\"hidden\" name=\"special_id_$count\" ";
                    echo "value=\"$data->id\">\n";
                }
            }

            echo "<td>$data->type</td>\n";
            echo "<td>$data->weight</td>\n";
            echo "<td>$data->value</td>\n";
            echo "<td>$data->comment</td>\n";
            echo "</tr>\n";
            echo "<tr>\n";
            foreach ( $special_actions as $special_action ) {
                echo "<td>\n";
                echo "<input type=\"radio\" name=\"special_handle_$count\" ";
                echo "value=\"$special_action\">\n";
                echo "</td>\n";
            }

            echo "<td>\n";
            echo "<select name=\"special_type_$count\" size=\"1\" ";
            echo "value=\"$data->type\">\n";
            foreach ( $types as $type ) {
                echo "<option>$type</option>\n";
            }
            echo "</select>\n";
            echo "</td>\n";
            echo "<td>\n";
            echo "<input type=\"text\" name=\"special_weight_$count\" ";
            echo "size=\"4\" value=\"$data->weight\">\n";
            echo "</td>\n";
            echo "<td>\n";
            echo "<input type=\"text\" name=\"special_value_$count\" ";
            echo "size=\"20\" value=\"$data->value\">\n";
            echo "</td>\n";
            echo "<td>\n";
            echo "<input type=\"text\" name=\"special_comment_$count\" ";
            echo "size=\"20\" value=\"$data->comment\">\n";
            echo "</td>\n";
            echo "</tr>\n";
        }
        echo "</table>\n";
        $old_count = $count;
        echo "<input type=\"hidden\" name=\"special_update\" ";
        echo "value=\"$old_count\">\n";
    }
    if ( $old_count < $special_count ) {
        echo "<h3>Additional DNS special records</h3>\n";
        echo "Entries with empty <strong>value</strong> fields will be ";
        echo "ignored.\n<br><br>\n";
        echo "<table  bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
        echo "<thead>\n";
        echo "<th></th>";  // spacer
        echo "<th>type</th><th>weight</th><th>value</th>";
        echo "<th>comment</th>\n";
        echo "</thead>\n";
    }
    for ( $count = $old_count; $count < $special_count; $count++ ) {
        if ( $count % 2 == 0 ) {
            echo "<tr bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
        } else {
            echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
        }
        echo "<td>&nbsp;";
        echo "<input type=\"hidden\" name=\"special_handle_$count\" ";
        echo "value=\"add\">";
        echo "</td>\n";
        echo "<td>\n";
        echo "<select name=\"special_type_$count\" size=\"1\">\n";
        foreach ( $types as $type ) {
            echo "<option>$type</option>\n";
        }
        echo "</select>\n";
        echo "</td>\n";
        echo "<td>\n";
        echo "<input type=\"text\" name=\"special_weight_$count\" ";
        echo "size=\"4\">\n";
        echo "</td>\n";
        echo "<td>\n";
        echo "<input type=\"text\" name=\"special_value_$count\" ";
        echo "size=\"20\">\n";
        echo "</td>\n";
        echo "<td>\n";
        echo "<input type=\"text\" name=\"special_comment_$count\" ";
        echo "size=\"20\">\n";
        echo "</td>\n";

        echo "</tr>\n";

    }
    if ( $old_count < $special_count ) {
        echo "</table>\n";
    }

    print_db_auth_form();

    echo "<br>\n";

    echo "<input type=\"hidden\" name=\"job\" value=\"edit_zone_commit\">\n";
    echo "<input type=\"hidden\" name=\"zone_id\" value=\"$zone_id\">\n";
    echo "<input type=\"hidden\" name=\"special_count\" ";
    echo "value=\"$special_count\">\n";
    echo "<input type=\"submit\" value=\" commit \">\n";
    echo "<input type=\"reset\" value=\" clear \">\n";

    echo "</form>\n";

    pg_close($database);
}


function edit_zone_commit ($post) {

    echo "<h1>edit zone - commit</h1>\n";
    print_short_zone_header($post[zone_id]);

    $database = db_signon($post['DB_USER'], $post['DB_PASSWORD']);
    if ( $database == -1 ) {
        textmodule_database_login_failure();

        return; 
    }


    $result = pg_exec($database, "BEGIN WORK"); // start transaction
    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to start transaction.<br>\n";
        echo "Database error message: <tt>$message</tt><br>\n";
        return;
    }

// first, update the zone data
    $records_added = 0;

    $fields = array("zone_name", "domain", "primary_ns", "network",
                    "refresh", "retry", "expire", "minimum", "zone_admin",
                    "comment");
    $last_field = $fields[(count($fields) - 1)];

    $sql = "UPDATE dns_zone SET ";

    foreach ( $fields as $field ) {
        $value = $post[$field];
        if ( $value == '' ) {  // check for empty value and set them to NULL
            $sql .= " $field = NULL ";
        } else {
            $value = addslashes($value);
            $sql .= " $field = '$value' ";
        }
        if ( $field != $last_field ) {
            $sql .= ", ";
        }
    }

    $sql .= " where id = $post[zone_id]";

#    echo "sql = <tt>|$sql|</tt></br>\n";

    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to update A record.\n";
        if ( preg_match("/Fail to add null value in not null/", $message) ) {
            echo "One or more mandatory fields were left empty.<br>\n";
        }   
        if ( preg_match("/pg_atoi: error in/", $message) ) {
            echo "Non-numeric characters in numeric field.<br>\n";
        }   
        echo "The database error message is: <tt>$message</tt><br>\n";
        $result = pg_exec($database, "ROLLBACK WORK");
        if ( $result == false ) { // hopefully _that_ never happens
            $message = pg_errormessage($database);
            echo "Failed to rollback transaction.<br>\n";
            echo "Database error message: <tt>$message</tt><br>\n";
        }
        return;
    } else { 
            $records_added += pg_cmdtuples($result);
    } 
           

    if ( $records_added == 1 ) {
        echo "Successfully updated $records_added zone.<br>\n";
    }
    if ( $records_added > 1 ) {
// that should never happen
        echo "Successfully updated $records_added zones.<br>\n";
        echo "<strong>Warning: More than one record was updated when exactly ";
        echo "one or no records should have been updated, something went ";
        echo "wrong!</strong>\n";
    
    }
    if ( $records_added == 0 ) {
        echo "No zone updated.<br>\n";
    }

// now, handle the special records
    $special_count = $post[special_count];
    $special_update = $post[update];
    $fields = array('type', 'weight', 'value', 'comment');
    $last_field = $fields[(count($fields) - 1)];

    $specials_added = 0;
    $specials_updated = 0;
    $specials_deleted = 0;

    for ( $count = 0; $count < $special_count; $count++ ) {
// first, check the update records
        $field = "special_handle_$count";
        $handling = $post[$field];
        $do_query = 0;
        if ( $handling == 'update' ) {  // UPDATE this record
            $sql = "UPDATE dns_special set ";
            $field = "special_type_$count";
            $value = addslashes($post[$field]);
            $sql .= "type = (SELECT id FROM dns_special_types where ";
            $sql .= "type = '$value'), ";
            $field = "special_weight_$count";
            $value = addslashes($post[$field]);
            $sql .= "weight = $value, ";
            $field = "special_value_$count";
            $value = addslashes($post[$field]);
            $sql .= "value = '$value', ";
            $field = "special_comment_$count";
            $value = addslashes($post[$field]);
            $sql .= "comment = '$value' ";
            $field = "special_id_$count";
            $sql .= " where id = $post[$field]";
            $do_query = 1;
        }

        if ( $handling == 'delete' ) {  // DELETE this record
            $sql = "DELETE FROM dns_special ";
            $field = "special_id_$count";
            $sql .= " where id = $post[$field]";
            $do_query = 1;
        }

        if ( $handling == 'add' ) {  // ADD new record
            // get all data for this record
            $weight = addslashes($post[$field]);
            $field = "special_value_$count";
            $value = addslashes($post[$field]);
            $field = "special_comment_$count";
            $comment = addslashes($post[$field]);
            $zone = $post[zone_id];
            if ( $value != '' ) {  // only work if value is set
                $sql = "INSERT INTO dns_special ";
                $sql .= "(type,weight,value,comment,zone) ";
                $sql .= "VALUES ( ";
                $field = "special_type_$count";
                $value = addslashes($post[$field]);
                $sql .= " (SELECT id FROM dns_special_types where ";
                $sql .= "type = '$value'), ";               
                $field = "special_weight_$count";
                $value = addslashes($post[$field]);
                $sql .= " $value, ";
                $field = "special_value_$count";
                $value = addslashes($post[$field]);
                $sql .= " '$value', ";
                $field = "special_comment_$count";
                $value = addslashes($post[$field]);
                $sql .= " '$value', ";
                $zone_id = $post[zone_id];
                $sql .= "$zone_id) ";


                $do_query = 1;
            } else {
                $do_query = 0;
            }
        }


        if ( $do_query == 1 ) {  
//            echo "sql = <tt>|$sql|</tt></br>\n";
   
            $result = pg_exec($database, $sql);
   
            if ( $result == false ) {
                $message = pg_errormessage($database);
                echo "Failed to $handling DNS special record.\n";
                if (preg_match("/Fail to add null value in not null/", 
                                                                 $message)){
                    echo "One or more mandatory fields were left ";
                    echo " empty.<br>\n";
                }
                if ( preg_match("/pg_atoi: error in/", $message) ) {
                    echo "Non-numeric characters in numeric field.<br>\n";
                }
                echo "The database error message is: <tt>$message</tt><br>\n";
                $result = pg_exec($database, "ROLLBACK WORK");
                if ( $result == false ) { // hopefully _that_ never happens
                    $message = pg_errormessage($database);
                    echo "Failed to rollback transaction.<br>\n";
                    echo "Database error message: <tt>$message</tt><br>\n";
                }
                return;
            } else {
                $tuples = pg_cmdtuples($result);
                if ( $handling == 'update' ) {
                    $specials_updated += pg_cmdtuples($result);
                }
                if ( $handling == 'delete' ) {
                    $specials_deleted += pg_cmdtuples($result);
                }
                if ( $handling == 'add' ) {
                    $specials_added += pg_cmdtuples($result);
                }
   
            }
        }
    }

    $result = pg_exec($database, "COMMIT WORK");
        if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to commit transaction.<br>\n";
        echo "Database error message: <tt>$message</tt><br>\n";
        $result = pg_exec($database, "ROLLBACK WORK");
        if ( $result == false ) { // hopefully _that_ never happens
            $message = pg_errormessage($database);
            echo "Failed to rollback transaction.<br>\n";
            echo "Database error message: <tt>$message</tt><br>\n";
        }
        return;
    }

    echo "Updated $specials_updated, deleted $specials_deleted and ";
    echo "added $specials_added DNS special records.<br>\n";


    pg_close($database);



}



?>
