<?php
# version: $Id: scass_dns_show_zone.php,v 1.9 2002/09/15 13:22:09 sshcvs Exp $

function show_zone ($zone_id) {

    $database = public_db_signon();
    $config_db = get_config_from_db($database);

    $sql = "select domain,primary_ns,network,zone_name,serial,last_update,zone_admin,comment,refresh,retry,expire,minimum from dns_zone where id=$zone_id";

    $result =  pg_exec($database, $sql);
    if ( $result == false ) {
        $error = pg_errormessage($database);
        echo "<tt>error: $error</tt>\n";
        return;
    }
    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "<h1>Error</h1>\n";
        echo "Selected zone_id not found, selected zone does not exist.";
        return -1;
    }

    $data = pg_fetch_object ($result, 0);
    pg_FreeResult($result);

    echo "<h2>Displaying DNS zone $data->zone_name ";
    echo "(domain $data->domain)</h2>\n";
    echo "<h3>general zone information</h3>\n";
    echo "<table  bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
    echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
    echo "<td>domain name</td><td>$data->domain</td>";
    echo "</tr>\n";
    echo "<tr><td>zone name</td><td>$data->zone_name &nbsp</td></tr>\n";
    echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
    echo "<td>primary ns </td><td>$data->primary_ns &nbsp</td>\n";
    echo "</tr>\n";
    echo "<tr><td>network </td><td>$data->network &nbsp</td></tr>\n";
    echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
    echo "<td>serial</td><td>$data->serial &nbsp</td>\n";
    echo "</tr>\n";
    echo "<tr><td>comment</td><td>$data->comment &nbsp</td></tr>\n";
    echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
    echo "<td>last update time</td><td>$data->last_update</td>\n";
    echo "</tr>\n";
    echo "<tr><td>refresh</td><td>$data->refresh seconds</td></tr>\n";
    echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
    echo "<td>retry</td><td>$data->retry seconds</td>\n";
    echo "</tr>\n";
    echo "<tr><td>expire</td><td>$data->expire seconds</td></tr>\n";
    echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
    echo "<td>SOA minimum</td><td>$data->minimum seconds</td>\n";
    echo "</tr>\n";
    echo "</table>\n";

    echo "<h3>DNS special records for this zone</h3>\n";
    $sql  = "SELECT t.type, s.weight, s.value, s.comment from ";
    $sql .= "dns_special_types t, dns_special s where ( zone = $zone_id ) ";
    $sql .= "and t.id = s.type";
    $result = pg_exec($database, $sql);
    if ( $result == false ) {
        $error = pg_errormessage($database);
        echo "Failed to load DNS special records.<br>\n";
        echo "Database error message: <tt>$message</tt><br>\n";
        return;
    }    
    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "No DNS special records found for this zone.<br>\n";
    } else {
        echo "<table bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
        echo "<thead>\n";
        echo "<th>type</th><th>weight</th><th>value</th>";
        echo "<th>comment</th>\n";
        echo "</thead>\n";
        for ( $count = 0; $count < $rows; $count++ ) {
            $data = pg_fetch_object ($result, $count);
            if ( $count % 2 == 1 ) {
                echo "<tr ";
                echo "bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
            } else {
                echo "<tr ";
                echo "bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
            }
            echo "<td>$data->type</td>\n";
            echo "<td>$data->weight</td>\n";
            echo "<td>$data->value</td>\n";
            echo "<td>$data->comment</td>\n";
            echo "</tr>\n";
        }
        echo "</table>\n";
    }
    

    echo "<h3>A records</h3>\n";

    $result = pg_exec($database, "select hostname,ip,hinfo,txt,comment,last_update from dns_mapping where zone=$zone_id order by hostname");
    if ( $result == false ) {
        $error = pg_errormessage($database);
        echo "<tt>error: $error</tt>\n";
        return;
    }
    $rows = pg_numrows($result);

    if ( $rows == 0 ) {
        echo "no records found\n";
    } else {
        echo "<table bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
        echo "<thead>\n";
        echo "<th>hostname</th><th>IP</th><th>TXT</th><th>HINFO</th>";
        echo "<th>last update (GMT)</th><th>comment</th>\n";
        echo "</thead>\n";

        for ( $count = 0; $count < $rows; $count++ ) {
            $data = pg_fetch_object ($result, $count);
            if ( $count % 2 == 1 ) {
                echo "<tr ";
                echo "bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
            } else {
                echo "<tr ";
                echo "bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
            }
            echo "<td>$data->hostname &nbsp;</td><td>$data->ip &nbsp;</td>";
            echo "<td>$data->txt &nbsp;</td><td>$data->hinfo &nbsp;</td>";
            echo "<td>$data->last_update &nbsp;</td>";
            echo "<td>$data->comment &nbsp;</td>\n";
            echo "</tr>\n";
        }
        echo "</table>\n";
    }
    pg_freeResult ($result);


    echo "<h3>alias records</h3>\n";

    display_dns_alias_table($database, "dns_alias.zone = $zone_id");

    pg_close($database);


}






?>
