<?php

// scass.fes - The frontendsystem of SCASS (System Configuration and
//             Administration Support System)
//
// Copyright (C) 2002  Alexander Schreiber <als@thangorodrim.de>
//
// This program is free software; you can redistribute it and/or modify 
// it under the terms of the GNU General Public License as published by 
// the Free Software Foundation; either version 2 of the License, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but 
// WITHOUT ANY WARRANTY; without even the implied warranty of  
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
// Public License for more details.


Header("Cache-Control: no-cache"); // avoid wrong form entries due to
                                   // caching

require("scass_lm_add.php");
require("scass_lm_show.php");
require("scass_lm_edit.php");
require("scass_lm_delete.php");

require("include/helpers.php");
require("include/db_helpers.php");
require("include/textmodules.php");
require("include/sidebar.php");
require("include/form_helper.php");


$current_module = 'license_manager';
$database = public_db_signon();
$module_description = get_module_description($database, $current_module);

echo "<HTML>\n";
echo "<HEAD>\n";
echo "<title>SCASS - $module_description</title>\n";
echo "</HEAD>\n";
echo "<BODY>\n";

include("include/style.html");
display_sidebar_top($database, $current_module);

echo "<h1>software license management</h1>\n";


// FIXME: verify all incoming data for validity!

// look for the job definition


if ( $HTTP_POST_VARS['job'] != '' ) {
    $job = $HTTP_POST_VARS['job'];
}

if ( $HTTP_GET_VARS['job'] != '' ) {
    $job = $HTTP_GET_VARS['job'];
}


switch ( $job ) {

    case 'simple_add_form_commit':
        if ( https_ok($_SERVER[HTTPS], 'simple_add_form_commit') ) {
            simple_add_form_commit($HTTP_POST_VARS);
        }
        break;


    case 'add_data_selector':
        add_data_selector();
        break;

    case 'add_software':
        if ( https_ok($_SERVER[HTTPS], 'add software') ) {
            add_software(5);
        }
        break;

    case 'add_software_commit':
        if ( https_ok($_SERVER[HTTPS], 'add software commit') ) {
            add_software_commit($HTTP_POST_VARS);
        }
        break;

    case 'add_platform':
        if ( https_ok($_SERVER[HTTPS], 'add platform') ) {
            add_platform(5);
        }
        break;

    case 'add_platform_commit':
        if ( https_ok($_SERVER[HTTPS], 'add platform commit') ) {
            add_platform_commit($HTTP_POST_VARS);
        }
        break;

    case 'add_vendor':
        if ( https_ok($_SERVER[HTTPS], 'add vendor') ) {
            add_vendor(5);
        }
        break;

    case 'add_license':
        if ( https_ok($_SERVER[HTTPS], 'add license') ) {
            add_license(5);
        }
        break;

    case 'add_software_class':
        if ( https_ok($_SERVER[HTTPS], 'add software class') ) {
            add_software_class(5);
        }
        break;

    case 'show_data_selector':
        show_data_selector();
        break;

    case 'show_platform':
        show_platform();
        break;
    case 'show_vendor':
        show_vendor();
        break;

    case 'show_license':
        show_license();
        break;

    case 'show_software_class':
        show_software_class();
        break;

    case 'show_software_full':
        show_software_full();
        break;
    case 'show_software_short':
        show_software_short('');
        break;

    case 'edit_data_selector':
        edit_data_selector();
        break;


    case 'edit_platform':
        if ( https_ok($_SERVER[HTTPS], 'edit platform') ) {
            edit_platform();
        }
        break;

    case 'edit_class':
        if ( https_ok($_SERVER[HTTPS], 'edit class') ) {
            edit_class();
        }
        break;

    case 'edit_vendor':
        if ( https_ok($_SERVER[HTTPS], 'edit vendor') ) {
            edit_vendor();
        }
        break;

    case 'edit_license':
        if ( https_ok($_SERVER[HTTPS], 'edit license') ) {
            edit_license();
        }
        break;

    case 'edit_software':
        if ( https_ok($_SERVER[HTTPS], 'edit software') ) {
            edit_software();
        }
        break;

    case 'edit_software_commit':
        if ( https_ok($_SERVER[HTTPS], 'edit software commit') ) {
            edit_software_commit($HTTP_POST_VARS);
        }
        break;


    case 'edit_simple_table_commit':
        if ( https_ok($_SERVER[HTTPS], 'edit simple table commit') ) {
            edit_simple_table_commit($HTTP_POST_VARS);
        }
        break;

    case 'delete_data_selector':
        delete_data_selector();
        break;


    case 'delete_platform':
        if ( https_ok($_SERVER[HTTPS], 'delete platform') ) {
            delete_platform();
        }
        break;

    case 'delete_class':
        if ( https_ok($_SERVER[HTTPS], 'delete class') ) {
            delete_class();
        }
        break;

    case 'delete_vendor':
        if ( https_ok($_SERVER[HTTPS], 'delete vendor') ) {
            delete_vendor();
        }
        break;

    case 'delete_license':
        if ( https_ok($_SERVER[HTTPS], 'delete license') ) {
            delete_license();
        }
        break;

    case 'delete_software':
        if ( https_ok($_SERVER[HTTPS], 'delete software') ) {
            delete_software();
        }
        break;



    case 'delete_from_simple_table_commit':
        if ( https_ok($_SERVER[HTTPS], 'delete from simple table commit') ) {
            delete_from_simple_table_commit($HTTP_POST_VARS);
        }
        break;

    case 'add_installation':
        if ( https_ok($_SERVER[HTTPS], 'add installation') ) {
            add_installation(5);
        }
        break;

    case 'add_installation_commit':
        if ( https_ok($_SERVER[HTTPS], 'add installation commit') ) {
            add_installation_commit($HTTP_POST_VARS);
        }
        break;

    case 'delete_installation':
        if ( https_ok($_SERVER[HTTPS], 'delete installation') ) {
            delete_installation();
        }
        break;

    case 'delete_installation_commit':
        if ( https_ok($_SERVER[HTTPS], 'delete installation commit') ) {
            delete_installation_commit($HTTP_POST_VARS);
        }
        break;

    case 'show_installation':
        show_installation();
        break;

    case 'edit_installation':
        if ( https_ok($_SERVER[HTTPS], 'edit installation') ) {
            edit_installation();
        }
        break;

    case 'edit_installation_commit':
        if ( https_ok($_SERVER[HTTPS], 'edit installation commit') ) {
            edit_installation_commit($HTTP_POST_VARS);
        }
        break;



    default:
        if ( $job != '' ) {
            print_error("unhandled job: |$job|");
        }
    break;

}



?>

<?php
include("include/nav_sidebar_end.html");
?>



</BODY>
</HTML>
