<?php
// add_* handlers
// author: Alexander Schreiber <als@thangorodrim.de>
// version: $Id: scass_lm_add.php,v 1.14 2002/08/21 17:59:32 sshcvs Exp $
//


function add_installation ($add_count) {

    $database = public_db_signon();
    $config_db = get_config_from_db($database);

    $description = get_menu_description($database, 'license_manager', 
                                        'add_installation');
    echo "<h1>$description</h2>\n";


    $software_names = get_column_from_table($database, 'lm_software',
                                            'software_name', '');

    $software_name_count = count($software_names);
    textmodule_add_entry_hint($add_count, 'count');
    echo "Entries with negative values for <strong>count</strong> are also ";
    echo "ignored.\n";
    echo "<br>\n";

    echo "<form action=\"scass_lm.php\" method=\"POST\">\n";

    $dark_bg = $config_db[HTMLTableDarkRowBackground];
    $light_bg = $config_db[HTMLTableLightRowBackground];

    echo "<table bgcolor=\"$light_bg\">\n";
    echo "<thead>\n";
    echo "<th>entry</th><th>count</th><th>software</th><th>location</th>";
    echo "<th>comment</th>\n";
    echo "</thead>\n";
    for ( $count = 0; $count < $add_count; $count++ ) {
        if ( $count % 2 == 0 ) {
            echo "<tr bgcolor=\"$dark_bg\">\n";
        } else {
            echo "<tr bgcolor=\"$light_bg\">\n";
        }
        $show_count = $count + 1;
        echo "<td align=\"right\">$show_count</td>\n";
        echo "<td>\n";
        $label = "count_${count}";
        form_entry_number_line($label, '');
        echo "</td>\n";
        echo "<td>\n";
        $label = "software_name_${count}";
        form_entry_select($label, $software_names);
        echo "</td>\n";
        echo "<td>\n";
        $label = "location_${count}";
        form_entry_text_line($label, '');
        echo "</td>\n"; 
        echo "<td>\n";
        $label = "comment_${count}";
        form_entry_text_line($label, '');
        echo "</td>\n";
        echo "</tr>\n";
    }

    echo "</table>\n";

    hidden_form_entry('job', 'add_installation_commit');
    hidden_form_entry('add_count', count($software_names));

    print_db_auth_form();

    echo "<input type=\"submit\" value=\" commit \">\n";
    echo "<input type=\"reset\" value=\" clear \">\n";

    echo "</form>\n";

    pg_close($database);
}


function add_installation_commit ($post) {

    echo "<h1>add installation - commit</h1>\n";

    $add_count = $post[add_count];
    
    $database = db_signon($post[DB_USER], $post[DB_PASSWORD]);
    if ( $database == -1 ) {
        textmodule_database_login_failure();

        return;
    }

    $records_added = 0;

    for ( $count = 0; $count < $add_count; $count++ ) {
        $install_count = $post["count_${count}"];
        $software_name = $post["software_name_${count}"];
        $location = $post["location_${count}"];
        $comment = $post["comment_${count}"];

        if ( ( $install_count != '' ) and ( $install_count > 0 ) ) {
            $sql  = "INSERT INTO lm_installation (software, location, ";
            $sql .= "comment, count) VALUES ((SELECT id FROM lm_software ";
            $sql .= "WHERE software_name = '$software_name' LIMIT 1), ";
            $sql .= "'$location', '$comment', $count)";

            $result = pg_exec($database, $sql);

            if ( $result == false ) {
                $message = pg_errormessage($database);
                echo "Failed to add installation record.\n";
                echo "The database error message is: <tt>$message</tt>\n";
            } else {
                $records_added += pg_cmdtuples($result);
            }
        }
    }

    textmodule_db_action_summary('inserted', $records_added);

}

function add_software ($add_count) {

// local helpers

    function table_entry_begin($bgcolor, $name) {
        echo "<tr bgcolor=\"$bgcolor\">\n";
        echo "<td>$name</td>\n";
        echo "<td>\n";
    }

    function table_entry_end () {
        print "</td>\n";
        print "</tr>\n";
    }

    $description = get_menu_description(-1, 'license_manager', 'add_software');
    echo "<h1>$description</h2>\n";

// first, gather all the data we need

    $database = public_db_signon();
    $config_db = get_config_from_db($database);

    $tables = array('platform', 'vendor', 'class', 'license');
    foreach ( $tables as $table ) {
        $sql = "select id, ${table}_name from lm_${table}";
        $result = pg_exec($database, $sql);
        if ( $result == false ) {
            $message = pg_errormessage($database);
            echo "Failed to select $table, database error: ";
            echo "<tt>$message</tt>\n";
            return -1;
        }
        $rows = pg_numrows($result);
        if ( $rows == 0 ) {
            echo "Failed to locate module: nothing found for table $table\n";
            echo "You should enter $table data first.\n";
            return -1;
        }

        $fields = "${table}_data";
        for ( $count = 0; $count < $rows; $count++ ) {
            $data = pg_fetch_object($result, $count);
            $field = "${table}_name";
            $key = $data->$field;
            ${$fields}[$key] = $data->id;
        }
        foreach ( ${$fields} as $stuff ) {

        }
    }
    pg_close($database);
    

// build the input form

    textmodule_add_entry_hint($add_count, 'software name');
    echo "<form action=\"scass_lm.php\" method=\"POST\">\n";

    $dark_bg = $config_db[HTMLTableDarkRowBackground];
    $light_bg = $config_db[HTMLTableLightRowBackground];

    for ( $count = 0; $count < $add_count; $count++ ) {
        $display_count = $count + 1;
        echo "<h2>entry $display_count</h2>\n";

        echo "<table  bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
//        echo "<thead>\n";
//        echo "<th>field</th><th>value</th>\n";
//        echo "</thead>\n";

        table_entry_begin($dark_bg, "software name");
        $name = "software_name_$count";
        form_entry_text_line($name, '');
        table_entry_end();

        table_entry_begin($light_bg, "description");
        $name = "description_$count";
        form_entry_text_line($name, '');
        table_entry_end();

        table_entry_begin($light_bg, "comment");
        $name = "comment_$count";
        form_entry_text_line($name, '');
        table_entry_end();

        $row_count = 0;
        foreach ( $tables as $selector ) {
            if ( $row_count++ % 2 == 0 ) {
                $bg = $dark_bg;
            } else {
                $bg = $light_bg;
            }
            table_entry_begin($bg, $selector);
            $this_selector = "${selector}_${count}";
            $selector_data = "${selector}_data";
            form_entry_select($this_selector, array_keys(${$selector_data}));

            table_entry_end();
        }

        table_entry_begin($dark_bg, "license count");
        $name = "total_licenses_$count";
        form_entry_number_line($name, '');
        table_entry_end();

        table_entry_begin($light_bg, "install source");
        $name = "install_source_$count";
        form_entry_text_line($name, '');
        table_entry_end();

        echo "</table>\n";
    }


    hidden_form_entry('job', 'add_software_commit');
    hidden_form_entry('add_count', $add_count);

    print_db_auth_form();

    echo "<input type=\"submit\" value=\" commit \">\n";
    echo "<input type=\"reset\" value=\" clear \">\n";

    echo "</form>\n";
}

function add_software_commit ($post) {

    $description = get_menu_description(-1, 'license_manager', 'add_software');
    echo "<h1>$description - commit</h2>\n";

    $database = db_signon($post['DB_USER'], $post['DB_PASSWORD']);
    if ( $database == -1 ) {
        textmodule_database_login_failure();

        return;
    }

// start collecting data
    $add_count = $post[add_count];

    $records_added = 0; 
// put the whole form into a single transaction

    $sql = 'BEGIN WORK';
    $result = pg_exec($database, $sql);
    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "failed to setup transaction<br>\n";
        echo "the database error message is: <tt>$message</tt>\n";
        return -1;
    }

    $fields = array('software_name', 'platform', 'vendor', 'class',
                    'license', 'total_licenses', 'description', 'comment',
                    'install_source');

    for ( $count = 0; $count < $add_count; $count++ ) {
        $key = "software_name_${count}";
        if ( $post[$key] == '' ) {
            continue;
        }
        foreach ( $fields as $field ) {
            $key = "${field}_${count}";
            $$field = addslashes($post[$key]);
            if ( $$field == '' ) {
                $$field = 'NULL';
            } else {
                $$field = "'${$field}'";
            }
        }
        
        if ( $total_licenses == 'NULL' ) {
            $total_licenses = 0;
        }
        $sql = "INSERT INTO lm_software (software_name, platform, ";
        $sql .= "vendor, class, license, description, comment, ";
        $sql .= "total_licenses, install_source) VALUES ($software_name, ";
        $sql .= "(select id from lm_platform where ";
        $sql .= "platform_name = $platform limit 1), (select id from ";
        $sql .= "lm_vendor where vendor_name = $vendor limit 1), (select ";
        $sql .= "id from lm_class where class_name = $class limit 1), ";
        $sql .= "(select id from lm_license where license_name = $license ";
        $sql .= "limit 1), $description, $comment, $total_licenses, ";
        $sql .= "$install_source)";

        $result = pg_exec($database, $sql);
        if ( $result == false ) {
            $message = pg_errormessage($database);
            echo "Failed to insert data.<br>\n";
            echo "Database error message: <tt>$message</tt><br>\n";
            $sql = "ROLLBACK WORK";
            $result = pg_exec($database, $sql);
            if ( $result == false ) {
                $message = pg_errormessage($database);
                echo "Rollback failed, situation is fucked.<br>\n";
                echo "Database error message: <tt>$message</tt><br>\n";
            }
            return -1;
        } else {
            $records_added++;
        }

    }
// oops, still here? so the stuff worked - great
    $sql = "COMMIT WORK";
    $result = pg_exec($database, $sql);
    if ( $result == false ) {  // uh, uh ... not so great
        $message = pg_errormessage($database);
        echo "Commit failed.<br>\n";
        echo "Database error message: <tt>$message</tt>\n";
        $result = pg_exec($database, $sql);
        if ( $result == false ) { // deep shit ... 
            $message = pg_errormessage($database);
            echo "Rollback failed, situation is fucked.<br>\n";
            echo "Database error message: <tt>$message</tt><br>\n";
        }
        return -1;
    }

    textmodule_db_action_summary('added', $records_added);

    pg_close($database);

    return 0;
}



function add_data_selector () {

    $menu_description = get_menu_description(-1, 'license_manager', 
                                             'add_data_selector');
    echo "<h1>data</h1>\n";
    echo "<br>\n";

    $entries = array("add_platform" => "add platform (up to 5)",
                     "add_vendor" => "add vendor (up to 5)",
                     "add_license" => "add license (up to 5)",
                     "add_software_class" => "add software class (up to 5)");


    echo "<ul>\n";
    foreach ( array_keys($entries) as $entry ) {
        echo "<li><a href=\"scass_lm.php?job=$entry\">";
        echo "$entries[$entry]</a></li>\n";

    }
    echo "</ul>\n";

}



function add_platform ($add_count) {

    $description = get_table_description(-1, 'lm_platform');

    $data_fields = array('platform_name' => 'platform name',
                         'comment' => 'comment');
    $example_fields = array('platform_name' => 'i386-linux',
                            'comment' => 'Linux on Intel x86');
    $required_fields = array('platform_name');
    $field_types = array('platform_name' => 'line',
                         'comment' => 'line');

    simple_add_form($add_count, "add $description", 'lm_platform', $data_fields,
                    $example_fields, $required_fields, $field_types);
}


function add_vendor ($add_count) {

    $description = get_table_description(-1, 'lm_vendor');

    $data_fields = array('vendor_name' => 'vendor name',
                         'comment' => 'comment');
    $example_fields = array('vendor_name' => 'SuSE GmbH',
                            'comment' => 'german Linux company');
    $required_fields = array('vendor_name');
    $field_types = array('vendor_name' => 'line',
                         'comment' => 'line');

    simple_add_form($add_count, "add $description", 'lm_vendor', $data_fields,
                    $example_fields, $required_fields, $field_types);
}

function add_software_class ($add_count) {

    $description = get_table_description(-1, 'lm_class');

    $data_fields = array('class_name' => 'class name',
                         'comment' => 'comment');
    $example_fields = array('class_name' => 'office applications',
                            'comment' => 'text processor, spreadsheet, ...');
    $required_fields = array('class_name');
    $field_types = array('class_name' => 'line',
                         'comment' => 'line');

    simple_add_form($add_count, "add $description", 'lm_class', $data_fields,
                    $example_fields, $required_fields, $field_types);
}

function add_license($add_count) {

    $description = get_table_description(-1, 'lm_license');

    $data_fields = array('license_name' => 'license name',
                         'license_text' => 'license text',
                         'comment' => 'comment');
    $example_fields = array('license_name' => 'GPL',
                            'license_text' => 'full text of license',
                            'comment' => 'GNU General Public License');
    $required_fields = array('license_name');
    $field_types = array('license_name' => 'shortline',
                         'license_text' => 'textarea',
                         'comment' => 'line');

    simple_add_form($add_count, "add $description", 'lm_license', 
                    $data_fields, $example_fields, $required_fields, 
                    $field_types);

}

?>
