<?php
// routines to delete license manager data
// author: Alexander Schreiber <als@thangorodrim.de>
// version: $Id: scass_lm_delete.php,v 1.5 2002/07/26 19:44:41 sshcvs Exp $


function delete_installation() {

    $database = public_db_signon();

    $description = get_table_description($database, 'lm_installation');

    $config_db = get_config_from_db($database);

    echo "<h1>delete $description</h1>\n";

    $sql  = "SELECT i.id, s.software_name, i.location, i.count, i.comment, ";
    $sql .= "i.last_update from lm_installation i, lm_software s where ";
    $sql .= "i.software = s.id order by s.software_name";

    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to select data, database error: <tt>$message</tt>\n";
        return -1;
    }

    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "Nothing found - no data inserted yet?\n";
        // an empty table is an unlikely, but still valid condition
        return 0;
    }

    $fields = array('software_name' => 'software package',
                    'location' => 'install location',
                    'count' => 'count',
                    'comment' =>'comment',
                    'last_update' => 'last updated');

    echo "<form action=\"scass_lm.php\" method=\"POST\">\n";

    show_delete_entry_table($result, $fields, $config_db);

    print_db_auth_form();

    echo "<br>\n";

    hidden_form_entry('job', 'delete_from_simple_table_commit');
    hidden_form_entry('delete_count', $rows);

    echo "<input type=\"submit\" value=\" commit \">\n";
    echo "<input type=\"reset\" value=\" clear \">\n";

    hidden_form_entry('table', 'lm_installation');
    $work = rawurlencode("delete $description");
    hidden_form_entry(title, $work);

    echo "</form>\n";

    pg_close($database);

    return 0;
}

function delete_data_selector () {

    $menu_description = get_menu_description(-1, 'license_manager',
                                             'delete_data_selector');
    echo "<h1>$menu_description</h1>\n";
    echo "<br>\n";

    $entries = array("delete_platform" => "delete platforms",
                     "delete_vendor" => "delete vendors",
                     "delete_license" => "delete licenses",
                     "delete_class" => "delete software classes",
                     "delete_software"  => "delete software entries");

    echo "<ul>\n";
    foreach ( array_keys($entries) as $entry ) {
        echo "<li><a href=\"scass_lm.php?job=$entry\">";
        echo "$entries[$entry]</a></li>\n";

    }
    echo "</ul>\n";
}


function delete_platform () {

    $fields = array('platform_name' => 'platform name',
                    'comment' => 'comment',
                    'last_update' => 'last update');
    delete_from_simple_table(-1, 'lm_platform', $fields, 'platform_name');

}

function delete_vendor () {

    $fields = array('vendor_name' => 'vendor name',
                    'comment' => 'comment',
                    'last_update' => 'last update');
    delete_from_simple_table(-1, 'lm_vendor', $fields, 'vendor_name');

}


function delete_license () {

    $fields = array('license_name' => 'license name',
                    'license_text' => 'full text of license',
                    'comment' => 'comment',
                    'last_update' => 'last update');
    delete_from_simple_table(-1, 'lm_license', $fields, 'license_name');

}


function delete_class () {

    $fields = array('class_name' => 'class name',
                    'comment' => 'comment',
                    'last_update' => 'last update');
    delete_from_simple_table(-1, 'lm_class', $fields, 'class_name');

}

function delete_software () {


    $database = public_db_signon();

    $description = get_table_description($database, 'lm_software');

    $config_db = get_config_from_db($database);

    echo "<h1>delete $description</h1>\n";

    $sql  = "SELECT lm_software.id, lm_software.software_name, ";
    $sql .= "lm_platform.platform_name, ";
    $sql .= "lm_vendor.vendor_name, lm_class.class_name, ";
    $sql .= "lm_license.license_name, lm_software.total_licenses, ";
    $sql .= "(lm_software.total_licenses - lm_software.reserved_licenses - ";
    $sql .= "lm_software.installed_licenses) as free_licenses, ";
    $sql .= "lm_software.last_update from lm_software,lm_class,lm_vendor,";
    $sql .= "lm_platform,lm_license where lm_software.platform = ";
    $sql .= "lm_platform.id and lm_software.vendor = lm_vendor.id and ";
    $sql .= "lm_software.class = lm_class.id and lm_software.license = ";
    $sql .= "lm_license.id order by lm_software.software_name";


    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to select data, database error: <tt>$message</tt>\n";
        return -1;
    }
    
    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "Nothing found - no data inserted yet?\n";
        // an empty table is an unlikely, but still valid condition
        return 0;
    }

    $fields = array('software_name' => 'software<br>name', 
                    'platform_name' => 'platform<br>&nbsp;',
                    'vendor_name' => 'vendor<br>&nbsp;',
                    'class_name' => 'class<br>&nbsp;',
                    'license_name' => 'license<br>&nbsp;',
                    'total_licenses' => 'total<br>licenses',
                    'free_licenses' => 'remaining<br>licenses',
                    'last_update' => 'last<br>update');
    
    echo "<form action=\"scass_lm.php\" method=\"POST\">\n";

    show_delete_entry_table($result, $fields, $config_db);

    print_db_auth_form();

    echo "<br>\n";

    hidden_form_entry('job', 'delete_from_simple_table_commit');
    hidden_form_entry('delete_count', $rows);

    echo "<input type=\"submit\" value=\" commit \">\n";
    echo "<input type=\"reset\" value=\" clear \">\n";

    hidden_form_entry('table', 'lm_software');
    $work = rawurlencode("delete $description");
    hidden_form_entry(title, $work);

    echo "</form>\n";

    pg_close($database);

    return 0;

}






























?>
