<?php
// various handlers for editing data
//
// author: Alexander Schreiber <als@thangorodrim.de>
// version: $Id: scass_lm_edit.php,v 1.7 2002/08/29 23:12:35 sshcvs Exp $
//


function edit_software () {

    function table_entry_begin($bgcolor, $name, $old_value) {
        echo "<tr bgcolor=\"$bgcolor\">\n";
        echo "<td>$name</td>\n";
        echo "<td>$old_value</td>\n";
        echo "<td>\n";
    }

    function table_entry_end () {
        print "</td>\n";
        print "</tr>\n";
    }



    $database = public_db_signon();
    $description = get_table_description($database, 'lm_software');
    $config_db = get_config_from_db($database);

    echo "<h1>edit $description</h1>\n";

    $tables = array('platform', 'vendor', 'class', 'license');
    foreach ( $tables as $table ) {
        $sql = "select id, ${table}_name from lm_${table}";
        $result = pg_exec($database, $sql);
        if ( $result == false ) {
            $message = pg_errormessage($database);
            echo "Failed to select $table, database error: ";
            echo "<tt>$message</tt>\n";
            return -1;
        }
        $rows = pg_numrows($result);
        if ( $rows == 0 ) {
            echo "Failed to locate module: nothing found\n";
            return -1;
        }

        $fields = "${table}_data";
        for ( $count = 0; $count < $rows; $count++ ) {
            $data = pg_fetch_object($result, $count);
            $field = "${table}_name";
            $key = $data->$field;
            ${$fields}[$key] = $data->id;
        }
        foreach ( ${$fields} as $stuff ) {

        }
    }

    $sql  = "SELECT s.id, s.software_name, p.platform_name, v.vendor_name, ";
    $sql .= "c.class_name, l.license_name, s.total_licenses, ";
    $sql .= "s.install_source, s.comment, s.last_update, ";
    $sql .= "s.installed_licenses, s.reserved_licenses, (s.total_licenses - ";
    $sql .= "s.reserved_licenses - s.installed_licenses) AS ";
    $sql .= "remaining_licenses from lm_software s, lm_vendor v, lm_class c, ";
    $sql .= "lm_license l, lm_platform p where s.platform = p.id and ";
    $sql .= "s.vendor = v.id and s.class = c.id and s.license = l.id";

    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to select tables, database error: <tt>$message</tt>\n";
        return -1;
    }

    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "Failed to locate software entries, nothing found\n";
        return -1;
    }

    $fields = array('software_name' => 'software package',
                    'platform_name' => 'platform',
                    'vendor_name' => 'vendor',
                    'class_name' => 'software class',
                    'license_name' => 'license type',
                    'description' => 'description',
                    'install_source' => 'install source',
                    'comment' => 'comment',
                    'total_licenses' => 'total license count',
                    'installed_licenses' => 'installed licenses',
                    'reserved_licenses' => 'reserved licenses',
                    'remaining_licenses' => 'remaining licenses');

    $selectors = array('platform_name' => 'platform_data',
                       'vendor_name' => 'vendor_data',
                       'class_name' => 'class_data',
                       'license_name' => 'license_data');

    $editable = array('software_name' => true,
                      'platform_name' => true,
                      'vendor_name' => true,
                      'class_name' => true,
                      'license_name' => true,
                      'description' => true,
                      'install_source' => true,
                      'comment' => true,
                      'total_licenses' => true,
                      'installed_licenses' => false,
                      'reserved_licenses' => false,
                      'remaining_licenses' => false);

    $edit_type = array('software_name' => 'text',
                       'platform_name' => 'select',
                       'vendor_name' => 'select',
                       'class_name' => 'select',
                       'license_name' => 'select',
                       'description' => 'text',
                       'install_source' => 'text',
                       'comment' => 'text',
                       'total_licenses' => 'number',
                       'installed_licenses' => 'text',
                       'reserved_licenses' => 'text',
                       'remaining_licenses' => 'text');

    echo "<form action=\"scass_lm.php\" method=\"POST\">\n";

    echo "<table bgcolor=\"$config_db[HTMLBackground]\">\n"; 
    for ( $count = 0; $count < $rows; $count++ ) {
        $display_count = $count + 1;
        $data = pg_fetch_object($result, $count);
        $column_count = 0;
        if ( $count > 0 ) {
            echo "<tr bgcolor=\"$config_db[HTMLBackground]\">";
            echo "<td>&nbsp;</td><td>&nbsp;</td>";
            echo "</tr>\n";
        }
        echo "<tr bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
        echo "<td>\n";
        echo "&nbsp;<h3>$display_count.</h3>";
        echo "<table width=\"100%\">\n";
        echo "<thead>\n";
        echo "<th>field name</th><th>old value</th><th>new value</th>\n";
        echo "</thead>\n";

        $work = "id_${count}";
        hidden_form_entry($work, $data->id);
        foreach ( array_keys($fields) as $field ) {
            $input_field = "${field}_${count}";
            table_entry_begin($bgcolor, $fields[$field], $data->$field);
            if ( $edit_type[$field] == 'select' ) {
                $this_selector = "$selectors[$field]";
                $selector_data = "${this_selector}";
                form_entry_select($input_field, 
                                  array_keys(${$selector_data}));
            } else {
                if ( $editable[$field] ) {
                    switch ( $edit_type[$field] ) {
                        case 'text': 
                            form_entry_text_line($input_field, $data->$field);
                            break;
                        case 'number':
                            form_entry_number_line($input_field, $data->$field);
                            break;

                        default:
                            break;
                    }

                } else {
                    print $data->$field;
                    print "\n";
                }
            }

            table_entry_end();
        }


        echo "</table>\n";
        $update = "_update_${count}";
        echo "<input type=\"checkbox\" name=\"$update\" value=\"true\">\n";
        echo "update this entry\n";
        echo "</td></tr>\n";
    }

    echo "</table>\n";
    hidden_form_entry('job', 'edit_software_commit');
    hidden_form_entry('update_count', $rows);

    print_db_auth_form();

    echo "<input type=\"submit\" value=\" commit \">\n";
    echo "<input type=\"reset\" value=\" clear \">\n";

    echo "</form>\n";

    pg_close($database);

}


function edit_software_commit ($post) {

    $description = get_menu_description(-1, 'license_manager', 'edit_software');
    echo "<h1>$description - commit</h2>\n";

    $database = db_signon($post['DB_USER'], $post['DB_PASSWORD']);
    if ( $database == -1 ) {
        textmodule_database_login_failure();

        return;
    }

    $update_count = $post[update_count];

    $records_updated = 0;

    $fields = array('id', 'software_name', 'platform_name', 'vendor_name', 
                    'class_name', 'license_name', 'total_licenses', 
                    'description', 'comment', 'install_source');

    for ( $count = 0; $count < $update_count; $count++ ) {
        $key = "_update_${count}";
        if ( $post[$key] == 'true' ) {
            foreach ( $fields as $field ) {
                $key = "${field}_${count}";
                $data = $post[$key];
                if ( ( $field == 'total_licenses' )  or
                     ( $field == 'id' ) ) {
                    if ( preg_match("/^\d+$/", $data) ) {
                        $$field = $data;
                    } else {
                        print_error("total_licenses must be a number");
                        $data = addslashes($data);
                        $$field = "'$data'";
                    }
                } else {
                    $data = addslashes($data);
                    $$field = "'$data'";
                }
            }
            $sql  = "UPDATE lm_software SET ";
            $sql .= "software_name = $software_name, ";
            $sql .= "platform = ( SELECT id from lm_platform where ";
            $sql .= "platform_name = $platform_name limit 1), ";
            $sql .= "vendor = ( SELECT id from lm_vendor where ";
            $sql .= "vendor_name = $vendor_name limit 1), ";
            $sql .= "class = ( SELECT id from lm_class where ";
            $sql .= "class_name = $class_name limit 1), ";
            $sql .= "license = ( SELECT id from lm_license where ";
            $sql .= "license_name = $license_name limit 1), ";
            $sql .= "total_licenses = $total_licenses, ";
            $sql .= "description = $description, ";
            $sql .= "comment = $comment, ";
            $sql .= "install_source = $install_source ";
            $sql .= "where id = $id";

            $result = pg_exec($database, $sql);
            if ( $result == false ) {
                $message = pg_errormessage($database);
                print_error("failed to update entry: $message");
            } else {
                $records_updated++;
            }
        }
    }

    textmodule_db_action_summary('updated', $records_updated);

    pg_close($database);

}


function edit_data_selector () {

    $menu_description = get_menu_description(-1, 'license_manager',
                                             'edit_data_selector');
    echo "<h1>$menu_description</h1>\n";
    echo "<br>\n";

    $entries = array("edit_platform" => "edit platforms",
                     "edit_vendor" => "edit vendors",
                     "edit_license" => "edit licenses",
                     "edit_class" => "edit software classes");

    echo "<ul>\n";
    foreach ( array_keys($entries) as $entry ) {
        echo "<li><a href=\"scass_lm.php?job=$entry\">";
        echo "$entries[$entry]</a></li>\n";

    }
    echo "</ul>\n";
}




function edit_platform () {

    $fields = array('platform_name' => 'platform name',
                    'comment' => 'comment');
    $field_types = array('platform_name' => 'line',
                         'comment' => 'longline');
    edit_simple_table(-1, 'lm_platform', $fields, $field_types, 
                      'platform_name', 'scass_lm.php');
}


function edit_class () {

    $fields = array('class_name' => 'class name',
                    'comment' => 'comment');
    $field_types = array('class_name' => 'line',
                         'comment' => 'longline');
    edit_simple_table(-1, 'lm_class', $fields, $field_types,
                      'class_name', 'scass_lm.php');
}

function edit_vendor () {

    $fields = array('vendor_name' => 'vendor name',
                    'comment' => 'comment');
    $field_types = array('vendor_name' => 'line',
                         'comment' => 'longline');
    edit_simple_table(-1, 'lm_vendor', $fields, $field_types,
                      'vendor_name', 'scass_lm.php');
}

function edit_license () {

    $fields = array('license_name' => 'license name',
                    'license_text' => 'license text',
                    'comment' => 'comment');
    $field_types = array('license_name' => 'line',
                         'license_text' => 'textarea',
                         'comment' => 'longline');
    edit_simple_table(-1, 'lm_license', $fields, $field_types,
                      'license_name', 'scass_lm.php');
}



function edit_installation() {

    $menu_description = get_menu_description(-1, 'license_manager',
                                             'edit_installation');
    echo "<h1>$menu_description</h1>\n";
    echo "<br>\n";

    $database = public_db_signon();
    $description = get_table_description($database, 'lm_software');
    $config_db = get_config_from_db($database);


    $software_names = get_column_from_table($database, 'lm_software', 
                                            'software_name', '');


    $sql  = "SELECT i.id, s.software_name, i.location, i.count, i.comment ";
    $sql .= "from lm_installation i, lm_software s where ";
    $sql .= "i.software = s.id order by s.software_name";

    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to select tables, database error: <tt>$message</tt>\n";
        return -1;
    }

    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "Failed to locate installation entries, nothing found\n";
        return -1;
    }

    $fields = array('software_name' => 'software package',
                    'location' => 'install location',
                    'count' => 'count',
                    'comment' =>'comment');

    echo "<form action=\"scass_lm.php\" method=\"POST\">\n";

// here should appear a nice edit table

    echo "<table bgcolor=\"$config_db[HTMLBackground]\">\n";
    echo "<thead>\n";
    echo "<th>entry</th>\n<th>update</th>\n";
    foreach ( $fields as $field_label ) {
        echo "<th>$field_label</th>\n";
    }
    echo "</thead>\n";

    for ( $count = 0; $count < $rows; $count++ ) {
        $data = pg_fetch_object($result, $count);
        if ( $count % 2 == 0 ) {
            echo "<tr bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
        } else {
            echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
        }
        $display_count = $count + 1;
        echo "<td align=\"right\">$display_count</td>\n";
        echo "<td align=\"center\">\n";
        $update = "_update_${count}";
        echo "<input type=\"checkbox\" name=\"$update\" value=\"true\">\n";
        echo "</td>\n";
        $field = 'count';
        foreach ( array_keys($fields) as $field ) {
            echo "<td>\n";
            $key = "${field}_${count}";
            if ( $field == 'comment' ) {
                form_entry_text_line($key, $data->$field);
            } elseif ( $field == 'count' )  {
                form_entry_number_line($key, $data->$field);
            } else {
                echo $data->$field;
            }
            echo "</td>\n";
        }
        $key = "id_${count}";
        hidden_form_entry($key, $data->id);
        echo "</tr>\n";
    }

    echo "</table>\n";

    hidden_form_entry('job', 'edit_installation_commit');
    hidden_form_entry('update_count', $rows);

    print_db_auth_form();

    echo "<input type=\"submit\" value=\" commit \">\n";
    echo "<input type=\"reset\" value=\" clear \">\n";

    echo "</form>\n";

    pg_close($database);

}


function edit_installation_commit($post) {

   $description = get_menu_description(-1, 'license_manager', 
                                       'edit_installation');
    echo "<h1>$description - commit</h2>\n";

    $database = db_signon($post['DB_USER'], $post['DB_PASSWORD']);
    if ( $database == -1 ) {
        textmodule_database_login_failure();

        return;
    }

    $update_count = $post[update_count];
    $records_updated = 0;

    $fields = array('id', 'count', 'comment');

    for ( $count = 0; $count < $update_count; $count++ ) {
        $update = "_update_${count}";
        if ( $post[$update] == 'true' ) {
            foreach ( $fields as $field ) {
                $key = "${field}_${count}";
                $data = $post[$key];
                if ( ( $field == 'id' ) or ( $field == 'count' ) ) {
                    if ( is_num($data) ) {
                        $values[$field] = $data;  // ok
                    } else {
                        $message  = "field $field must be an integer, ";
                        $message .= "but is  $data";
                        $data = addslashes($data); // let the DB deal with it
                        $values[$field] = "'$data'";
                    }
                } else {
                    $data = addslashes($data);
                    $values[$field] = "'$data'";
                }
            }

            $sql  = "UPDATE lm_installation SET ";
            $sql .= "count = $values[count], comment = $values[comment] ";
            $sql .= "where id = $values[id]";

            $result = pg_exec($database, $sql);
            if ( $result == false ) {
                $message = pg_errormessage($database);
                print_error("failed to update entry: $message");
            } else {
                $records_updated++;
            }

        }
    }

    textmodule_db_action_summary('updated', $records_updated);

    pg_close($database);
}




?>
