<?php
// show_* handlers for license_manager
// author: Alexander Schreiber <als@thangorodrim.de>
// version: $Id: scass_lm_show.php,v 1.14 2002/08/12 12:44:24 sshcvs Exp $
//

function show_installation() {
    function table_entry_begin($bgcolor, $name) {
        echo "<tr bgcolor=\"$bgcolor\">\n";
        echo "<td>$name</td>\n";
    }

    function table_entry_end () {
        print "</tr>\n";
    }


    $database = public_db_signon();

    $description = get_table_description($database, 'lm_installation');

    $config_db = get_config_from_db($database);

    echo "<h1>show $description</h1>\n";

    $sql  = "SELECT i.id, s.software_name, i.location, i.count, i.comment, ";
    $sql .= "i.last_update from lm_installation i, lm_software s where ";
    $sql .= "i.software = s.id order by s.software_name";

    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to select tables, database error: <tt>$message</tt>\n";
        return -1;
    }

    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "Failed to locate installation entries, nothing found\n";
        return -1;
    }

    $fields = array('software_name' => 'software package',
                    'location' => 'install location',
                    'count' => 'count',
                    'comment' =>'comment',
                    'last_update' => 'last updated');

    echo "<table bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
    echo "<thead>\n";
    echo "<th>entry</th>\n";
    foreach ( $fields as $field ) {
        echo "<th>$field</th>\n";
    }
    echo "</thead>\n";
    for ( $count = 0; $count < $rows; $count++ ) {
        $data = pg_fetch_object($result, $count);
        if ( $count % 2 == 1 ) {
            echo "<tr bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
        } else {
            echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
        }

        $display_count = $count + 1;
        echo "<td align=\"right\">$display_count</td>\n";
        foreach ( array_keys($fields) as $field ) {
            $value = nl2br(htmlentities(stripslashes($data->$field)));
            if ( $column_count % 2 == 1 ) {
                $bg_color = $config_db[HTMLTableLightRowBackground];
            } else {
                $bg_color = $config_db[HTMLTableDarkRowBackground];
            }

            echo "<td>$value</td>";
        }
        echo "</tr>\n";
    }

    echo "</table>\n";


}


function show_data_selector () {

    $menu_description = get_menu_description(-1, 'license_manager',
                                             'show_data_selector');
    echo "<h1>$menu_description</h1>\n";
    echo "<br>\n";

    $entries = array("show_platform" => "show platforms",
                     "show_vendor" => "show vendors",
                     "show_license" => "show licenses",
                     "show_software_class" => "show software classes");

    echo "<ul>\n";
    foreach ( array_keys($entries) as $entry ) {
        echo "<li><a href=\"scass_lm.php?job=$entry\">";
        echo "$entries[$entry]</a></li>\n";

    }
    echo "</ul>\n";
}


function show_platform () {
// dumps complete list of platform entries

    $fields = array('platform_name' => 'platform name',
                    'comment' => 'comment',
                    'last_update' => 'last update');
    display_simple_table(-1, 'lm_platform', $fields, 'platform_name');

}

function show_vendor () {
// dumps complete list of platform entries

    $fields = array('vendor_name' => 'vendor name',
                    'comment' => 'comment',
                    'last_update' => 'last update');
    display_simple_table(-1, 'lm_vendor', $fields, 'vendor_name');

}


function show_license () {
// dumps complete list of platform entries

    $fields = array('license_name' => 'license name',
                    'license_text' => 'full text of license',
                    'comment' => 'comment',
                    'last_update' => 'last update');
    display_simple_table(-1, 'lm_license', $fields, 'license_name');

}


function show_software_class () {
// dumps complete list of platform entries

    $fields = array('class_name' => 'class name',
                    'comment' => 'comment',
                    'last_update' => 'last update');
    display_simple_table(-1, 'lm_class', $fields, 'class_name');

}


function show_software_full() {
// full listing of software

    function table_entry_begin($bgcolor, $name) {
        echo "<tr bgcolor=\"$bgcolor\">\n";
        echo "<td>$name</td>\n";
    }

    function table_entry_end () {
        print "</tr>\n";
    }


    $database = public_db_signon();

    $description = get_table_description($database, 'lm_software');

    $config_db = get_config_from_db($database);

    echo "<h1>show $description</h1>\n";

    $sql  = "SELECT sw.software_name, pf.platform_name, ";
    $sql .= "vn.vendor_name, cl.class_name, ls.license_name, sw.description, ";
    $sql .= "sw.comment, sw.total_licenses, sw.installed_licenses, ";
    $sql .= "sw.reserved_licenses, (sw.total_licenses - sw.reserved_licenses ";
    $sql .= "- sw.installed_licenses) AS remaining_licenses from lm_software ";
    $sql .= "sw, lm_platform pf, lm_vendor vn, lm_class cl, lm_license ls ";
    $sql .= "where sw.platform = pf.id and sw.vendor = vn.id and sw.class = ";
    $sql .= "cl.id and sw.license = ls.id order by sw.software_name";

    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to select tables, database error: <tt>$message</tt>\n";
        return -1;
    }

    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "Failed to locate software entries, nothing found\n";
        return -1;
    }

    $fields = array('software_name' => 'software package',
                    'platform_name' => 'platform',
                    'vendor_name' => 'vendor',
                    'class_name' => 'software class',   
                    'license_name' => 'license',
                    'description' => 'description',
                    'comment' => 'comment',
                    'total_licenses' => 'total license count',
                    'installed_licenses' => 'installed licenses',
                    'reserved_licenses' => 'reserved licenses',
                    'remaining_licenses' => 'remaining licenses');

//    echo "<table bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
  
    echo "<table bgcolor=\"$config_db[HTMLBackground]\">\n"; 
    for ( $count = 0; $count < $rows; $count++ ) {
        $data = pg_fetch_object($result, $count);
        $column_count = 0;
        if ( $count > 0 ) {
            echo "<tr bgcolor=\"$config_db[HTMLBackground]\">";
            echo "<td>&nbsp;</td><td>&nbsp;</td>";
            echo "</tr>\n";
        }
        echo "<tr><td>\n";
        echo "<table bgcolor=\"$config_db[HTMLTableLightRowBackground]\" ";
        echo "width=\"100%\n;>\n";
        foreach ( array_keys($fields) as $field ) {
            $column_count++;
            $value = nl2br(htmlentities(stripslashes($data->$field)));
            if ( $column_count % 2 == 1 ) {
                $bg_color = $config_db[HTMLTableLightRowBackground];
            } else {
                $bg_color = $config_db[HTMLTableDarkRowBackground];
            }
            table_entry_begin($bg_color, "<strong>$fields[$field]</strong>");
            if ( $field == 'remaining_licenses' ) {
                if ( ( $value == 0 ) and ( $data->total_licenses > 0 ) )  {
                    echo "<td bgcolor=\"orange\">$value</td>\n";
                } elseif ( ( $value < 0 ) and ( $data->total_licenses > 0 ) ) {
                    echo "<td bgcolor=\"red\">$value</td>\n";
                } else {
                    echo "<td>$value</td>";
                }
            } else {
                echo "<td>$value</td>";
            }
            table_entry_end();


        }
        echo "</table>\n";
        echo "</td></tr>\n";
    }

    echo "</table>\n";

    pg_close($database);
}


function show_software_short ($condition) {
// short listing of software
// $condition => list only entries matching condition, can be empty

    function table_entry_begin($bgcolor, $name) {
        echo "<tr bgcolor=\"$bgcolor\">\n";
        echo "<td>$name</td>\n";
    }

    function table_entry_end () {
        print "</tr>\n";
    }

// catch empty $condition
    if ( $condition == '' ) {
        $condition = 'true';
    }

    $database = public_db_signon();

    $description = get_table_description($database, 'lm_software');

    $config_db = get_config_from_db($database);

    echo "<h1>show $description</h1>\n";

    $sql  = "SELECT sw.software_name, pf.platform_name, ";
    $sql .= "sw.comment, sw.total_licenses, "; 
    $sql .= "(sw.total_licenses - sw.reserved_licenses ";
    $sql .= "- sw.installed_licenses) AS remaining_licenses from lm_software ";
    $sql .= "sw, lm_platform pf ";
    $sql .= "where sw.platform = pf.id ";
    $sql .= "and $condition ";
    $sql .= "order by sw.software_name";

    $result = pg_exec($database, $sql);

    if ( $result == false ) {
        $message = pg_errormessage($database);
        echo "Failed to select tables, database error: <tt>$message</tt>\n";
        return -1;
    }

    $rows = pg_numrows($result);
    if ( $rows == 0 ) {
        echo "Failed to locate software entries, nothing found\n";
        return -1;
    }

    $fields = array('software_name' => 'software package',
                    'platform_name' => 'platform',
                    'total_licenses' => 'total licenses',
                    'remaining_licenses' => 'remaining licenses');


    echo "<table bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
    echo "<thead>\n";
    foreach ( $fields as $field ) {
        echo "<th>$field</th>\n";
    }
    echo "</thead>\n";
    for ( $count = 0; $count < $rows; $count++ ) {
        $data = pg_fetch_object($result, $count);
        if ( $count % 2 == 1 ) {
            echo "<tr bgcolor=\"$config_db[HTMLTableLightRowBackground]\">\n";
        } else {
            echo "<tr bgcolor=\"$config_db[HTMLTableDarkRowBackground]\">\n";
        }

        foreach ( array_keys($fields) as $field ) {
            $value = nl2br(htmlentities(stripslashes($data->$field)));
            if ( $column_count % 2 == 1 ) {
                $bg_color = $config_db[HTMLTableLightRowBackground];
            } else {
                $bg_color = $config_db[HTMLTableDarkRowBackground];
            }

            if ( $field == 'remaining_licenses' ) {
                if ( ( $value == 0 ) and ( $data->total_licenses > 0 ) )  {
                    echo "<td bgcolor=\"orange\">$value</td>\n"; 
                } elseif ( ( $value < 0 ) and ( $data->total_licenses > 0 ) ) {
                    echo "<td bgcolor=\"red\">$value</td>\n";
                } else { 
                    echo "<td>$value</td>";
                }
            } else {
                echo "<td>$value</td>";
            }
        }
        echo "</tr>\n";
    }

    echo "</table>\n";

    pg_close($database);



}















?>
