;;;; file: net-repl.lisp
;;;; 
;;;; A REPL listening on the network.
;;;;
;;;; Copyright (C) 2006 Alexander Schreiber
;;;;
;;;; This library is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU Library General Public
;;;; License as published by the Free Software Foundation; either
;;;; version 2 of the License.
;;;;
;;;; This library is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;; Library General Public License for more details.
;;;;
;;;; You should have received a copy of the GNU Library General Public
;;;; License along with this library; if not, write to the Free
;;;; Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;;;
;;;; author : Alexander Schreiber <als@thangorodrim.de>
;;;; version: $Id: simple-tcp.lisp 1518 2006-10-26 20:11:53Z als $
;;;;
;;;;


(defpackage :lns.net-repl
  (:use :common-lisp)
  (:documentation
   "A REPL listening on the network for LNS.")
  (:export #:start-repl
           #:net-repl
           ))


(in-package :lns.net-repl)



(defvar *address* "0.0.0.0" "default listen address for the services")

;;; ----

  
  

(defun net-repl (stream ip port peer-ip peer-port)
  "Basic net REPL."
  (declare (ignore ip port peer-ip peer-port))
  (let ((*error-output* stream)
        (*standard-output* stream)
        (*standard-input* stream))
    (loop
     (print
      (eval
       (read-line))))))

;;; ------

(defun start-repl ()
  "Starts the whole load."
  ;; first, load some fortune cookies - tweak the path if needed
  (if 
   (lns:register-service-handler *address*
                                 8888
                                 #'lns.net-repl:net-repl)
   (format t "Registered echo-server to 4000/tcp~%")
   (format t "Failed to register echo-server to 4000/tcp~%")))  

              
